/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.dsl;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.tasks.Jar;
import org.springframework.boot.gradle.tasks.buildinfo.BuildInfo;
import org.springframework.boot.gradle.tasks.buildinfo.BuildInfoProperties;

public class SpringBootExtension {
    private final Project project;
    private String mainClassName;

    public SpringBootExtension(Project project) {
        this.project = project;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public void setMainClassName(String mainClassName) {
        this.mainClassName = mainClassName;
    }

    public void buildInfo() {
        this.buildInfo(null);
    }

    public void buildInfo(Action<BuildInfo> configurer) {
        TaskContainer tasks = this.project.getTasks();
        TaskProvider bootBuildInfo = tasks.register("bootBuildInfo", BuildInfo.class, this::configureBuildInfoTask);
        this.project.getPlugins().withType(JavaPlugin.class, plugin -> {
            tasks.getByName("classes").dependsOn(new Object[]{bootBuildInfo.get()});
            this.project.afterEvaluate(evaluated -> {
                BuildInfoProperties properties = ((BuildInfo)((Object)((Object)((Object)bootBuildInfo.get())))).getProperties();
                if (properties.getArtifact() == null) {
                    properties.setArtifact(this.determineArtifactBaseName());
                }
            });
        });
        if (configurer != null) {
            configurer.execute(bootBuildInfo.get());
        }
    }

    private void configureBuildInfoTask(BuildInfo task) {
        task.setGroup("build");
        task.setDescription("Generates a META-INF/build-info.properties file.");
        task.getConventionMapping().map("destinationDir", () -> new File(this.determineMainSourceSetResourcesOutputDir(), "META-INF"));
    }

    private File determineMainSourceSetResourcesOutputDir() {
        return ((SourceSet)((JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main")).getOutput().getResourcesDir();
    }

    private String determineArtifactBaseName() {
        Jar artifactTask = this.findArtifactTask();
        return artifactTask != null ? (String)artifactTask.getArchiveBaseName().get() : null;
    }

    private Jar findArtifactTask() {
        Jar artifactTask = (Jar)this.project.getTasks().findByName("bootWar");
        if (artifactTask != null) {
            return artifactTask;
        }
        return (Jar)this.project.getTasks().findByName("bootJar");
    }
}

