/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceScanner {
    private static final Log LOG = LogFactory.getLog((Class)ResourceScanner.class);
    private String[] roots;
    private Class callingClass;

    public ResourceScanner(String[] roots, Class callingClass) {
        this.roots = roots;
        this.callingClass = callingClass;
    }

    public List scanForResources() throws IOException, URISyntaxException {
        return this.scanForResources(new Filter(){

            public boolean accept(URL resource) {
                return true;
            }
        });
    }

    public List scanForResources(Filter filter) throws IOException, URISyntaxException {
        ArrayList resources = new ArrayList();
        for (int a = 0; a < this.roots.length; ++a) {
            String jarFilePath;
            URL[] rootResources;
            String root = this.roots[a].replace('.', '/');
            if ("".equals(root)) {
                rootResources = this.getResources("META-INF", class$com$opensymphony$xwork$util$ResourceScanner == null ? ResourceScanner.class$("com.opensymphony.xwork.util.ResourceScanner") : class$com$opensymphony$xwork$util$ResourceScanner);
                for (int c = 0; c < rootResources.length; ++c) {
                    if (!rootResources[c].toString().startsWith("jar:file:") || rootResources[c].toString().indexOf("!") <= 0) continue;
                    jarFilePath = rootResources[c].toString().substring(9, rootResources[c].toString().indexOf("!"));
                    resources.addAll(this.loadRootResourcesFromJarFile(rootResources[c].toString().substring(0, rootResources[c].toString().indexOf("!")), new File(URLDecoder.decode(jarFilePath, "UTF-8")), filter, null));
                }
            }
            rootResources = this.getResources(root, class$com$opensymphony$xwork$util$ResourceScanner == null ? ResourceScanner.class$("com.opensymphony.xwork.util.ResourceScanner") : class$com$opensymphony$xwork$util$ResourceScanner);
            for (int b = 0; b < rootResources.length; ++b) {
                if (rootResources[b].toString().startsWith("file:")) {
                    resources.addAll(this.loadResourcesFromClassPath(new File(rootResources[b].toURI()), filter, null));
                    continue;
                }
                if (!rootResources[b].toString().startsWith("jar:file:") || rootResources[b].toString().indexOf("!") <= 0) continue;
                jarFilePath = rootResources[b].toString().substring(9, rootResources[b].toString().indexOf("!"));
                resources.addAll(this.loadResourcesFromJarFile(rootResources[b].toString().substring(0, rootResources[b].toString().indexOf("!")), root, new File(URLDecoder.decode(jarFilePath, "UTF-8")), filter, null));
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List loadRootResourcesFromJarFile(String jarFilePath, File jarFile, Filter filter, List resources) throws IOException {
        if (resources == null) {
            resources = new ArrayList<URL>();
        }
        JarFile _jarFile = null;
        try {
            _jarFile = new JarFile(jarFile);
            Enumeration<JarEntry> jarFileEntries = _jarFile.entries();
            while (jarFileEntries.hasMoreElements()) {
                URL _resource;
                JarEntry jarEntry = jarFileEntries.nextElement();
                String fullResourcePath = jarEntry.getName();
                if (fullResourcePath.indexOf("/") >= 0 || (_resource = new URL(jarFilePath + "!/" + fullResourcePath)) == null || !filter.accept(_resource)) continue;
                resources.add(_resource);
            }
        }
        finally {
            if (jarFile != null) {
                _jarFile.close();
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List loadResourcesFromJarFile(String jarFilePath, String root, File jarFile, Filter filter, List resources) throws IOException {
        if (resources == null) {
            resources = new ArrayList<URL>();
        }
        JarFile _jarFile = null;
        try {
            _jarFile = new JarFile(jarFile);
            Enumeration<JarEntry> jarFileEntries = _jarFile.entries();
            while (jarFileEntries.hasMoreElements()) {
                URL _resource;
                JarEntry jarEntry = jarFileEntries.nextElement();
                String fullResourcePath = jarEntry.getName();
                if (!fullResourcePath.startsWith(root) || fullResourcePath.substring(root.length()).indexOf("/") >= 0 || (_resource = new URL(jarFilePath + "!/" + fullResourcePath)) == null || !filter.accept(_resource)) continue;
                resources.add(_resource);
            }
        }
        finally {
            if (jarFile != null) {
                _jarFile.close();
            }
        }
        return resources;
    }

    public List loadResourcesFromClassPath(File rootFile, Filter filter, List resources) throws URISyntaxException, MalformedURLException {
        if (resources == null) {
            resources = new ArrayList<URL>();
        }
        if (rootFile.isDirectory()) {
            File[] children = rootFile.listFiles();
            for (int a = 0; a < children.length; ++a) {
                if (!children[a].isFile() || !filter.accept(children[a].toURL())) continue;
                resources.add(children[a].toURL());
            }
        }
        return resources;
    }

    protected URL[] getResources(String resourceName, Class callingClass) throws IOException {
        URL[] urls = Collections.list(Thread.currentThread().getContextClassLoader().getResources(resourceName)).toArray(new URL[0]);
        if (urls.length == 0) {
            urls = Collections.list(ResourceScanner.class.getClassLoader().getResources(resourceName)).toArray(new URL[0]);
        }
        if (urls.length == 0) {
            urls = Collections.list(callingClass.getClassLoader().getResources(resourceName)).toArray(new URL[0]);
        }
        return urls;
    }

    public static interface Filter {
        public boolean accept(URL var1);
    }
}

