/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.util;

import com.opensymphony.xwork.util.ObjectProxy;
import com.opensymphony.xwork.util.OgnlContextState;
import com.opensymphony.xwork.util.OgnlTools;
import java.lang.reflect.Method;
import java.util.Map;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import ognl.enhance.ExpressionCompiler;
import ognl.enhance.UnsupportedCompilationException;

public class ObjectProxyPropertyAccessor
implements PropertyAccessor {
    public Object getProperty(Map context, Object target, Object name) throws OgnlException {
        ObjectProxy proxy = (ObjectProxy)target;
        this.setupContext(context, proxy);
        return OgnlRuntime.getPropertyAccessor(proxy.getValue().getClass()).getProperty(context, target, name);
    }

    public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
        ObjectProxy proxy = (ObjectProxy)target;
        this.setupContext(context, proxy);
        OgnlRuntime.getPropertyAccessor(proxy.getValue().getClass()).setProperty(context, target, name, value);
    }

    public Class getPropertyClass(OgnlContext ognlcontext, Object target, Object name) {
        ObjectProxy proxy = (ObjectProxy)target;
        Object tmp = proxy.getValue();
        if (tmp != null) {
            return tmp.getClass();
        }
        return Object.class;
    }

    public String getSourceAccessor(OgnlContext ognlcontext, Object target, Object name) {
        ObjectProxy proxy = (ObjectProxy)target;
        Object tmp = proxy.getValue();
        String beanName = ((String)name).replaceAll("\"", "");
        if (tmp != null) {
            Method m = OgnlRuntime.getReadMethod(tmp.getClass(), (String)beanName);
            Class type = OgnlRuntime.getCompiler().getSuperOrInterfaceClass(m, proxy.getValue().getClass());
            ExpressionCompiler.addCastString((OgnlContext)ognlcontext, (String)("((" + type.getName() + ")"));
            ognlcontext.setCurrentType(type);
            ognlcontext.setCurrentAccessor(ObjectProxy.class);
            return "." + m.getName() + "()";
        }
        return "";
    }

    public String getSourceSetter(OgnlContext ognlcontext, Object target, Object name) {
        ObjectProxy proxy = (ObjectProxy)target;
        Object tmp = proxy.getValue();
        String beanName = ((String)name).replaceAll("\"", "");
        if (tmp != null) {
            Method m = OgnlRuntime.getWriteMethod(tmp.getClass(), (String)beanName);
            Class type = OgnlRuntime.getCompiler().getSuperOrInterfaceClass(m, proxy.getValue().getClass());
            if (m.getParameterTypes().length != 1) {
                throw new UnsupportedCompilationException("Object property accessors can only support single parameter setters.");
            }
            Class<?> param = m.getParameterTypes()[0];
            String conversion = null;
            if (param.isPrimitive()) {
                Class wrapClass = OgnlRuntime.getPrimitiveWrapperClass(param);
                conversion = OgnlRuntime.getCompiler().createLocalReference(ognlcontext, "((" + wrapClass.getName() + ")ognl.OgnlOps#convertValue($3," + wrapClass.getName() + ".class, true))." + OgnlTools.getPrimitiveValueGetter(wrapClass), param);
            } else {
                conversion = param.isArray() ? OgnlRuntime.getCompiler().createLocalReference(ognlcontext, "(" + ExpressionCompiler.getCastString(param) + ")ognl.OgnlOps#toArray($3," + param.getComponentType().getName() + ".class)", param) : OgnlRuntime.getCompiler().createLocalReference(ognlcontext, "(" + param.getName() + ")ognl.OgnlOps#convertValue($3," + param.getName() + ".class)", param);
            }
            ExpressionCompiler.addCastString((OgnlContext)ognlcontext, (String)("((" + type.getName() + ")"));
            ognlcontext.setCurrentType(type);
            ognlcontext.setCurrentAccessor(ObjectProxy.class);
            return "." + m.getName() + "(" + conversion + ")";
        }
        return "";
    }

    private void setupContext(Map context, ObjectProxy proxy) {
        OgnlContextState.setLastBeanClassAccessed(context, proxy.getLastClassAccessed());
        OgnlContextState.setLastBeanPropertyAccessed(context, proxy.getLastPropertyAccessed());
    }
}

