/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.validator.validators;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.TextParseUtil;
import com.opensymphony.xwork.validator.DelegatingValidatorContext;
import com.opensymphony.xwork.validator.ShortCircuitableValidator;
import com.opensymphony.xwork.validator.ValidationException;
import com.opensymphony.xwork.validator.Validator;
import com.opensymphony.xwork.validator.ValidatorContext;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ValidatorSupport
implements Validator,
ShortCircuitableValidator {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected String defaultMessage = "";
    protected String messageKey = null;
    private ValidatorContext validatorContext;
    private boolean shortCircuit;
    private boolean parse = false;
    private String type;
    private String[] messageParameters;

    public void setParse(boolean parse) {
        this.parse = parse;
    }

    public boolean getParse() {
        return this.parse;
    }

    public void setDefaultMessage(String message) {
        this.defaultMessage = message;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public String getMessage(Object object) {
        String message;
        OgnlValueStack stack = ActionContext.getContext().getValueStack();
        boolean pop = false;
        if (!stack.getRoot().contains(object)) {
            stack.push(object);
            pop = true;
        }
        stack.push(this);
        if (this.messageKey != null) {
            if (this.defaultMessage == null || this.defaultMessage.trim().equals("")) {
                this.defaultMessage = this.messageKey;
            }
            if (this.validatorContext == null) {
                this.validatorContext = new DelegatingValidatorContext(object);
            }
            ArrayList<Object> parsedMessageParameters = null;
            if (this.messageParameters != null) {
                parsedMessageParameters = new ArrayList<Object>();
                for (int a = 0; a < this.messageParameters.length; ++a) {
                    if (this.messageParameters[a] == null) continue;
                    try {
                        Object val = stack.findValue(this.messageParameters[a]);
                        parsedMessageParameters.add(val);
                        continue;
                    }
                    catch (Exception e) {
                        this.log.warn((Object)("exception while parsing message parameter [" + this.messageParameters[a] + "]"), (Throwable)e);
                        parsedMessageParameters.add(this.messageParameters[a]);
                    }
                }
            }
            message = this.validatorContext.getText(this.messageKey, this.defaultMessage, parsedMessageParameters);
        } else {
            message = this.defaultMessage;
        }
        message = TextParseUtil.translateVariables(message, stack);
        stack.pop();
        if (pop) {
            stack.pop();
        }
        return message;
    }

    public void setMessageKey(String key) {
        this.messageKey = key;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageParameters(String[] messageParameters) {
        this.messageParameters = messageParameters;
    }

    public String[] getMessageParameters() {
        return this.messageParameters;
    }

    public void setShortCircuit(boolean shortcircuit) {
        this.shortCircuit = shortcircuit;
    }

    public boolean isShortCircuit() {
        return this.shortCircuit;
    }

    public void setValidatorContext(ValidatorContext validatorContext) {
        this.validatorContext = validatorContext;
    }

    public ValidatorContext getValidatorContext() {
        return this.validatorContext;
    }

    public void setValidatorType(String type) {
        this.type = type;
    }

    public String getValidatorType() {
        return this.type;
    }

    protected Object conditionalParse(String expression) {
        if (this.parse) {
            OgnlValueStack stack = ActionContext.getContext().getValueStack();
            return TextParseUtil.translateVariables('$', expression, stack);
        }
        return expression;
    }

    protected Object getFieldValue(String name, Object object) throws ValidationException {
        OgnlValueStack stack = ActionContext.getContext().getValueStack();
        boolean pop = false;
        if (!stack.getRoot().contains(object)) {
            stack.push(object);
            pop = true;
        }
        Object retVal = stack.findValue(name);
        if (pop) {
            stack.pop();
        }
        return retVal;
    }

    protected void addActionError(Object object) {
        this.validatorContext.addActionError(this.getMessage(object));
    }

    protected void addFieldError(String propertyName, Object object) {
        this.validatorContext.addFieldError(propertyName, this.getMessage(object));
    }
}

