/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.validator;

import com.opensymphony.xwork.TextProvider;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeTextProvider
implements TextProvider {
    private static final Log LOG = LogFactory.getLog((Class)CompositeTextProvider.class);
    private List textProviders = new ArrayList();

    public CompositeTextProvider(List textProviders) {
        Iterator i = textProviders.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof TextProvider) {
                this.textProviders.add(obj);
                continue;
            }
            LOG.warn((Object)("object [" + obj + "] provided in list [" + textProviders + "] is not a TextProvider instance, ignoring it"));
        }
    }

    public CompositeTextProvider(TextProvider[] textProviders) {
        this(Arrays.asList(textProviders));
    }

    public boolean hasKey(String key) {
        Iterator i = this.textProviders.iterator();
        while (i.hasNext()) {
            TextProvider _textProvider = (TextProvider)i.next();
            if (!_textProvider.hasKey(key)) continue;
            return true;
        }
        return false;
    }

    public String getText(String key) {
        return this.getText(key, key, Collections.EMPTY_LIST);
    }

    public String getText(String key, String defaultValue) {
        return this.getText(key, defaultValue, Collections.EMPTY_LIST);
    }

    public String getText(String key, String defaultValue, final String obj) {
        return this.getText(key, defaultValue, new ArrayList(){
            {
                this.add(obj);
            }
        });
    }

    public String getText(String key, List args) {
        return this.getText(key, key, args);
    }

    public String getText(String key, String[] args) {
        return this.getText(key, key, args);
    }

    public String getText(String key, String defaultValue, List args) {
        Iterator i = this.textProviders.iterator();
        while (i.hasNext()) {
            TextProvider _textProvider = (TextProvider)i.next();
            String msg = _textProvider.getText(key, defaultValue, args);
            if (msg == null || msg.equals(defaultValue)) continue;
            return msg;
        }
        return defaultValue;
    }

    public String getText(String key, String defaultValue, String[] args) {
        Iterator i = this.textProviders.iterator();
        while (i.hasNext()) {
            TextProvider _textProvider = (TextProvider)i.next();
            String msg = _textProvider.getText(key, defaultValue, args);
            if (msg == null || msg.equals(defaultValue)) continue;
            return msg;
        }
        return defaultValue;
    }

    public String getText(String key, String defaultValue, List args, OgnlValueStack stack) {
        Iterator i = this.textProviders.iterator();
        while (i.hasNext()) {
            TextProvider _textProvider = (TextProvider)i.next();
            String msg = _textProvider.getText(key, defaultValue, args, stack);
            if (msg == null || msg.equals(defaultValue)) continue;
            return msg;
        }
        return defaultValue;
    }

    public String getText(String key, String defaultValue, String[] args, OgnlValueStack stack) {
        Iterator i = this.textProviders.iterator();
        while (i.hasNext()) {
            TextProvider _textProvider = (TextProvider)i.next();
            String msg = _textProvider.getText(key, defaultValue, args, stack);
            if (msg == null || msg.equals(defaultValue)) continue;
            return msg;
        }
        return defaultValue;
    }

    public ResourceBundle getTexts(String bundleName) {
        Iterator i = this.textProviders.iterator();
        while (i.hasNext()) {
            TextProvider _textProvider = (TextProvider)i.next();
            ResourceBundle bundle = _textProvider.getTexts(bundleName);
            if (bundle == null) continue;
            return bundle;
        }
        return null;
    }

    public ResourceBundle getTexts() {
        Iterator i = this.textProviders.iterator();
        while (i.hasNext()) {
            TextProvider _textProvider = (TextProvider)i.next();
            ResourceBundle bundle = _textProvider.getTexts();
            if (bundle == null) continue;
            return bundle;
        }
        return null;
    }
}

