/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.util;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.opensymphony.xwork.XworkException;
import com.opensymphony.xwork.config.ConfigurationManager;
import com.opensymphony.xwork.util.CompoundRoot;
import com.opensymphony.xwork.util.XWorkConverter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import ognl.ASTStaticMethod;
import ognl.Node;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.TypeConverter;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OgnlUtil {
    private static final Log log = LogFactory.getLog((Class)OgnlUtil.class);
    private static ConcurrentMap parsedExpressions = CopyOnWriteMap.builder().newHashMap();
    private static ConcurrentMap beanInfoCache = CopyOnWriteMap.builder().newHashMap();
    private static volatile Boolean useOgnlEnhancement = null;
    private static volatile Boolean isStaticMethodCallAllowed = null;

    public static void setProperties(Map props, Object o, Map context) {
        OgnlUtil.setProperties(props, o, context, false);
    }

    public static void setProperties(Map props, Object o, Map context, boolean throwPropertyExceptions) {
        if (props == null) {
            return;
        }
        Ognl.setTypeConverter((Map)context, (TypeConverter)XWorkConverter.getInstance());
        Object oldRoot = Ognl.getRoot((Map)context);
        Ognl.setRoot((Map)context, (Object)o);
        Iterator iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String expression = (String)entry.getKey();
            OgnlUtil.internalSetProperty(expression, entry.getValue(), o, context, throwPropertyExceptions);
        }
        Ognl.setRoot((Map)context, (Object)oldRoot);
    }

    public static void setProperties(Map properties, Object o) {
        OgnlUtil.setProperties(properties, o, false);
    }

    public static void setProperties(Map properties, Object o, boolean throwPropertyExceptions) {
        Map context = Ognl.createDefaultContext((Object)o);
        OgnlUtil.setProperties(properties, o, context, throwPropertyExceptions);
    }

    public static void setProperty(String name, Object value, Object o, Map context) {
        OgnlUtil.setProperty(name, value, o, context, false);
    }

    public static void setProperty(String name, Object value, Object o, Map context, boolean throwPropertyExceptions) {
        Ognl.setTypeConverter((Map)context, (TypeConverter)XWorkConverter.getInstance());
        Object oldRoot = Ognl.getRoot((Map)context);
        Ognl.setRoot((Map)context, (Object)o);
        OgnlUtil.internalSetProperty(name, value, o, context, throwPropertyExceptions);
        Ognl.setRoot((Map)context, (Object)oldRoot);
    }

    public static Object getRealTarget(String property, Map context, Object root) throws OgnlException {
        if ("top".equals(property)) {
            return root;
        }
        if (root instanceof CompoundRoot) {
            CompoundRoot cr = (CompoundRoot)root;
            try {
                Iterator iterator = cr.iterator();
                while (iterator.hasNext()) {
                    Object target = iterator.next();
                    if (!OgnlRuntime.hasSetProperty((OgnlContext)((OgnlContext)context), target, (Object)property) && !OgnlRuntime.hasGetProperty((OgnlContext)((OgnlContext)context), target, (Object)property) && OgnlRuntime.getIndexedPropertyType((OgnlContext)((OgnlContext)context), target.getClass(), (String)property) == OgnlRuntime.INDEXED_PROPERTY_NONE) continue;
                    return target;
                }
            }
            catch (IntrospectionException ex) {
                throw new OgnlException("Cannot figure out real target class", (Throwable)ex);
            }
            return null;
        }
        return root;
    }

    public static void setValue(String name, Map context, Object root, Object value) throws OgnlException {
        Object expr;
        if (OgnlUtil.isUseOgnlEnhancement()) {
            try {
                Node node = Ognl.compileExpression((OgnlContext)((OgnlContext)context), (Object)root, (String)name);
                if (OgnlUtil.isSafe(node)) {
                    node.getAccessor().set((OgnlContext)context, root, value);
                }
                return;
            }
            catch (Exception e) {
                log.warn((Object)"unable to set value using OGNL expression compilation mode, falling back to expression parsing", (Throwable)e);
            }
        }
        if (OgnlUtil.isSafe(expr = OgnlUtil.compile(name))) {
            Ognl.setValue((Object)expr, (Map)context, (Object)root, (Object)value);
        }
    }

    private static boolean isSafe(Object expr) {
        boolean isSafe;
        boolean bl = isSafe = !(expr instanceof ASTStaticMethod) || OgnlUtil.isStaticMethodCallAllowed();
        if (!isSafe) {
            log.warn((Object)("Expression " + expr + " is not safe and will not be evaluated"));
        }
        return isSafe;
    }

    public static Object getValue(String name, Map context, Object root) throws OgnlException {
        Object expr;
        if (OgnlUtil.isUseOgnlEnhancement()) {
            try {
                Object result;
                Node node = Ognl.compileExpression((OgnlContext)((OgnlContext)context), (Object)root, (String)name);
                Object object = result = OgnlUtil.isSafe(node) ? node.getAccessor().get((OgnlContext)context, root) : null;
                if (result != null) {
                    return result;
                }
            }
            catch (Exception e) {
                log.warn((Object)"unable to get value using OGNL expression compilation mode, falling back to expression parsing", (Throwable)e);
            }
        }
        return OgnlUtil.isSafe(expr = OgnlUtil.compile(name)) ? Ognl.getValue((Object)expr, (Map)context, (Object)root) : null;
    }

    public static Object getValue(String name, Map context, Object root, Class resultType) throws OgnlException {
        Object expr;
        if (OgnlUtil.isUseOgnlEnhancement()) {
            try {
                Node node = Ognl.compileExpression((OgnlContext)((OgnlContext)context), (Object)root, (String)name);
                return OgnlUtil.isSafe(node) ? node.getAccessor().get((OgnlContext)context, root) : null;
            }
            catch (Exception e) {
                log.warn((Object)"unable to get value using OGNL expression compilation mode, falling back to expression parsing", (Throwable)e);
            }
        }
        return OgnlUtil.isSafe(expr = OgnlUtil.compile(name)) ? Ognl.getValue((Object)expr, (Map)context, (Object)root, (Class)resultType) : null;
    }

    public static Object compile(String expression) throws OgnlException {
        Object o = parsedExpressions.get(expression);
        if (o == null) {
            o = Ognl.parseExpression((String)expression);
            parsedExpressions.putIfAbsent(expression, o);
        }
        return o;
    }

    public static void copy(Object from, Object to, Map context, Collection exclusions, Collection inclusions) {
        int i;
        PropertyDescriptor[] toPds;
        PropertyDescriptor[] fromPds;
        if (from == null || to == null) {
            log.warn((Object)"Attempting to copy from or to a null source. This is illegal and is bein skipped. This may be due to an error in an OGNL expression, action chaining, or some other event.");
            return;
        }
        Map contextFrom = Ognl.createDefaultContext((Object)from);
        Ognl.setTypeConverter((Map)contextFrom, (TypeConverter)XWorkConverter.getInstance());
        Map contextTo = Ognl.createDefaultContext((Object)to);
        Ognl.setTypeConverter((Map)contextTo, (TypeConverter)XWorkConverter.getInstance());
        try {
            fromPds = OgnlUtil.getPropertyDescriptors(from);
            toPds = OgnlUtil.getPropertyDescriptors(to);
        }
        catch (IntrospectionException e) {
            log.error((Object)"An error occured", (Throwable)e);
            return;
        }
        HashMap<String, PropertyDescriptor> toPdHash = new HashMap<String, PropertyDescriptor>();
        for (i = 0; i < toPds.length; ++i) {
            PropertyDescriptor toPd = toPds[i];
            toPdHash.put(toPd.getName(), toPd);
        }
        for (i = 0; i < fromPds.length; ++i) {
            PropertyDescriptor toPd;
            PropertyDescriptor fromPd = fromPds[i];
            if (fromPd.getReadMethod() == null) continue;
            boolean copy = true;
            if (exclusions != null && exclusions.contains(fromPd.getName())) {
                copy = false;
            } else if (inclusions != null && !inclusions.contains(fromPd.getName())) {
                copy = false;
            }
            if (!copy || (toPd = (PropertyDescriptor)toPdHash.get(fromPd.getName())) == null || toPd.getWriteMethod() == null) continue;
            try {
                Object expr;
                Node node;
                Object value = null;
                boolean tryExpressionParsing = true;
                if (OgnlUtil.isUseOgnlEnhancement()) {
                    try {
                        node = Ognl.compileExpression((OgnlContext)((OgnlContext)contextFrom), (Object)from, (String)fromPd.getName());
                        value = OgnlUtil.isSafe(node) ? node.getAccessor().get((OgnlContext)contextFrom, from) : null;
                        tryExpressionParsing = false;
                    }
                    catch (Exception e) {
                        tryExpressionParsing = true;
                        log.warn((Object)"unable to get value using OGNL expression compilation mode, falling back to expression parsing", (Throwable)e);
                    }
                }
                if (tryExpressionParsing) {
                    expr = OgnlUtil.compile(fromPd.getName());
                    value = OgnlUtil.isSafe(expr) ? Ognl.getValue((Object)expr, (Map)contextFrom, (Object)from) : null;
                }
                tryExpressionParsing = true;
                if (OgnlUtil.isUseOgnlEnhancement()) {
                    try {
                        node = Ognl.compileExpression((OgnlContext)((OgnlContext)contextTo), (Object)to, (String)fromPd.getName());
                        if (OgnlUtil.isSafe(node)) {
                            node.getAccessor().set((OgnlContext)contextTo, to, value);
                        }
                        tryExpressionParsing = false;
                    }
                    catch (Exception e) {
                        tryExpressionParsing = true;
                        log.warn((Object)"unable to set value using OGNL expression compilation mode, falling back to expression parsing", (Throwable)e);
                    }
                }
                if (!tryExpressionParsing || !OgnlUtil.isSafe(expr = OgnlUtil.compile(fromPd.getName()))) continue;
                Ognl.setValue((Object)expr, (Map)contextTo, (Object)to, (Object)value);
                continue;
            }
            catch (OgnlException e) {
                // empty catch block
            }
        }
    }

    public static void copy(Object from, Object to, Map context) {
        OgnlUtil.copy(from, to, context, null, null);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Object source) throws IntrospectionException {
        BeanInfo beanInfo = OgnlUtil.getBeanInfo(source);
        return beanInfo.getPropertyDescriptors();
    }

    public static Map getBeanMap(Object source) throws IntrospectionException, OgnlException {
        HashMap<String, Object> beanMap = new HashMap<String, Object>();
        Map sourceMap = Ognl.createDefaultContext((Object)source);
        PropertyDescriptor[] propertyDescriptors = OgnlUtil.getPropertyDescriptors(source);
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
            String propertyName = propertyDescriptor.getDisplayName();
            Method readMethod = propertyDescriptor.getReadMethod();
            if (readMethod != null) {
                Object value = null;
                boolean tryExpressionParsing = true;
                if (OgnlUtil.isUseOgnlEnhancement()) {
                    try {
                        Node node = Ognl.compileExpression((OgnlContext)((OgnlContext)sourceMap), (Object)source, (String)propertyName);
                        value = OgnlUtil.isSafe(node) ? node.getAccessor().get((OgnlContext)sourceMap, source) : null;
                        tryExpressionParsing = false;
                    }
                    catch (Exception e) {
                        tryExpressionParsing = true;
                        log.warn((Object)"unable to get value using OGNL expression compilation mode, falling back to expression parsing", (Throwable)e);
                    }
                }
                if (tryExpressionParsing) {
                    Object expr = OgnlUtil.compile(propertyName);
                    value = OgnlUtil.isSafe(expr) ? Ognl.getValue((Object)expr, (Map)sourceMap, (Object)source) : null;
                }
                beanMap.put(propertyName, value);
                continue;
            }
            beanMap.put(propertyName, "There is no read method for " + propertyName);
        }
        return beanMap;
    }

    public static BeanInfo getBeanInfo(Object from) throws IntrospectionException {
        BeanInfo beanInfo = (BeanInfo)beanInfoCache.get(from.getClass());
        if (beanInfo == null) {
            beanInfo = Introspector.getBeanInfo(from.getClass(), Object.class);
            beanInfoCache.putIfAbsent(from.getClass(), beanInfo);
        }
        return beanInfo;
    }

    static void internalSetProperty(String name, Object value, Object o, Map context, boolean throwPropertyExceptions) {
        try {
            OgnlUtil.setValue(name, context, o, value);
        }
        catch (OgnlException e) {
            Throwable exception;
            Throwable reason = e.getReason();
            String msg = "Caught OgnlException while setting property '" + name + "' on type '" + o.getClass().getName() + "'.";
            Throwable throwable = exception = reason == null ? e : reason;
            if (throwPropertyExceptions) {
                log.error((Object)msg, exception);
                throw new XworkException(msg, exception);
            }
            log.warn((Object)msg, exception);
        }
    }

    static boolean isUseOgnlEnhancement() {
        if (useOgnlEnhancement == null) {
            try {
                String value = ConfigurationManager.getConfiguration().getParameter("useOgnlEnhancement");
                useOgnlEnhancement = value != null && "true".equalsIgnoreCase(value) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (Exception e) {
                log.warn((Object)"Failed to get xwork parameter [useOgnlEnhancement] assuming it's false", (Throwable)e);
                useOgnlEnhancement = Boolean.FALSE;
            }
        }
        return useOgnlEnhancement;
    }

    static boolean isStaticMethodCallAllowed() {
        if (isStaticMethodCallAllowed == null) {
            try {
                String value = ConfigurationManager.getConfiguration().getParameter("struts.ognl.allowStaticMethodAccess");
                isStaticMethodCallAllowed = BooleanUtils.toBoolean((String)value);
            }
            catch (Exception e) {
                log.warn((Object)"Failed to get xwork parameter [struts.ognl.allowStaticMethodAccess] assuming it's false", (Throwable)e);
                isStaticMethodCallAllowed = Boolean.FALSE;
            }
        }
        return isStaticMethodCallAllowed;
    }

    public static Object escapeLiteral(String s) {
        return "\"" + StringEscapeUtils.escapeJava((String)s) + "\"";
    }
}

