/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor;

import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.config.entities.ExceptionMappingConfig;
import com.opensymphony.xwork.interceptor.ExceptionHolder;
import com.opensymphony.xwork.interceptor.Interceptor;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExceptionMappingInterceptor
implements Interceptor {
    protected static final Log log = LogFactory.getLog((Class)ExceptionMappingInterceptor.class);
    protected Log categoryLogger;
    protected boolean logEnabled = false;
    protected String logCategory;
    protected String logLevel;

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    public String getLogCategory() {
        return this.logCategory;
    }

    public void setLogCategory(String logCatgory) {
        this.logCategory = logCatgory;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        String result;
        try {
            result = invocation.invoke();
        }
        catch (Exception e) {
            List exceptionMappings;
            String mappedResult;
            if (this.logEnabled) {
                this.handleLogging(e);
            }
            if ((mappedResult = this.findResultFromExceptions(exceptionMappings = invocation.getProxy().getConfig().getExceptionMappings(), e)) != null) {
                result = mappedResult;
                this.publishException(invocation, new ExceptionHolder(e));
            }
            throw e;
        }
        return result;
    }

    protected void handleLogging(Exception e) {
        if (this.logCategory != null) {
            if (this.categoryLogger == null) {
                this.categoryLogger = LogFactory.getLog((String)this.logCategory);
            }
            this.doLog(this.categoryLogger, e);
        } else {
            this.doLog(log, e);
        }
    }

    protected void doLog(Log logger, Exception e) {
        if (this.logLevel == null) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
            return;
        }
        if ("trace".equalsIgnoreCase(this.logLevel)) {
            logger.trace((Object)e.getMessage(), (Throwable)e);
        } else if ("debug".equalsIgnoreCase(this.logLevel)) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
        } else if ("info".equalsIgnoreCase(this.logLevel)) {
            logger.info((Object)e.getMessage(), (Throwable)e);
        } else if ("warn".equalsIgnoreCase(this.logLevel)) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        } else if ("error".equalsIgnoreCase(this.logLevel)) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        } else if ("fatal".equalsIgnoreCase(this.logLevel)) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
        } else {
            throw new IllegalArgumentException("LogLevel [" + this.logLevel + "] is not supported");
        }
    }

    private String findResultFromExceptions(List exceptionMappings, Throwable t) {
        String result = null;
        if (exceptionMappings != null) {
            int deepest = Integer.MAX_VALUE;
            Iterator iter = exceptionMappings.iterator();
            while (iter.hasNext()) {
                ExceptionMappingConfig exceptionMappingConfig = (ExceptionMappingConfig)iter.next();
                int depth = this.getDepth(exceptionMappingConfig.getExceptionClassName(), t);
                if (depth < 0 || depth >= deepest) continue;
                deepest = depth;
                result = exceptionMappingConfig.getResult();
            }
        }
        return result;
    }

    public int getDepth(String exceptionMapping, Throwable t) {
        return this.getDepth(exceptionMapping, t.getClass(), 0);
    }

    private int getDepth(String exceptionMapping, Class exceptionClass, int depth) {
        if (exceptionClass.getName().indexOf(exceptionMapping) != -1) {
            return depth;
        }
        if (exceptionClass.equals(Throwable.class)) {
            return -1;
        }
        return this.getDepth(exceptionMapping, exceptionClass.getSuperclass(), depth + 1);
    }

    protected void publishException(ActionInvocation invocation, ExceptionHolder exceptionHolder) {
        invocation.getStack().push(exceptionHolder);
    }
}

