/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.validator.validators;

import com.opensymphony.xwork.validator.ValidationException;
import com.opensymphony.xwork.validator.validators.FieldValidatorSupport;

public class DoubleRangeFieldValidator
extends FieldValidatorSupport {
    String maxInclusive = null;
    String minInclusive = null;
    String minExclusive = null;
    String maxExclusive = null;
    Double maxInclusiveValue = null;
    Double minInclusiveValue = null;
    Double minExclusiveValue = null;
    Double maxExclusiveValue = null;

    public void validate(Object object) throws ValidationException {
        Double value;
        String fieldName = this.getFieldName();
        try {
            Object obj = this.getFieldValue(fieldName, object);
            if (obj == null) {
                return;
            }
            value = Double.valueOf(obj.toString());
        }
        catch (NumberFormatException e) {
            return;
        }
        this.parseParameterValues();
        if (this.maxInclusiveValue != null && value.compareTo(this.maxInclusiveValue) > 0 || this.minInclusiveValue != null && value.compareTo(this.minInclusiveValue) < 0 || this.maxExclusiveValue != null && value.compareTo(this.maxExclusiveValue) >= 0 || this.minExclusiveValue != null && value.compareTo(this.minExclusiveValue) <= 0) {
            this.addFieldError(fieldName, object);
        }
    }

    private void parseParameterValues() {
        this.minInclusiveValue = this.parseDouble(this.minInclusive);
        this.maxInclusiveValue = this.parseDouble(this.maxInclusive);
        this.minExclusiveValue = this.parseDouble(this.minExclusive);
        this.maxExclusiveValue = this.parseDouble(this.maxExclusive);
    }

    private Double parseDouble(String value) {
        block3: {
            if (value != null) {
                try {
                    return Double.valueOf(value);
                }
                catch (NumberFormatException e) {
                    if (!this.log.isWarnEnabled()) break block3;
                    this.log.warn((Object)("DoubleRangeFieldValidator - [parseDouble]: Unable to parse given double parameter " + value));
                }
            }
        }
        return null;
    }

    public void setMaxInclusive(String maxInclusive) {
        this.maxInclusive = maxInclusive;
    }

    public String getMaxInclusive() {
        return this.maxInclusive;
    }

    public void setMinInclusive(String minInclusive) {
        this.minInclusive = minInclusive;
    }

    public String getMinInclusive() {
        return this.minInclusive;
    }

    public String getMinExclusive() {
        return this.minExclusive;
    }

    public void setMinExclusive(String minExclusive) {
        this.minExclusive = minExclusive;
    }

    public String getMaxExclusive() {
        return this.maxExclusive;
    }

    public void setMaxExclusive(String maxExclusive) {
        this.maxExclusive = maxExclusive;
    }
}

