/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.util;

import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.util.OgnlContextState;
import com.opensymphony.xwork.util.XWorkConverter;
import java.util.Map;
import ognl.MapPropertyAccessor;
import ognl.OgnlException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XWorkMapPropertyAccessor
extends MapPropertyAccessor {
    private static final Log _log = LogFactory.getLog((Class)XWorkMapPropertyAccessor.class);
    private static final String[] INDEX_ACCESS_PROPS = new String[]{"size", "isEmpty", "keys", "values"};
    private static final XWorkConverter _converter = XWorkConverter.getInstance();

    public Object getProperty(Map context, Object target, Object name) throws OgnlException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Entering getProperty (" + context + "," + target + "," + name + ")"));
        }
        OgnlContextState.updateCurrentPropertyPath(context, name);
        if (name instanceof String && this.contains(INDEX_ACCESS_PROPS, (String)name)) {
            return super.getProperty(context, target, name);
        }
        Object result = null;
        try {
            result = super.getProperty(context, target, name);
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        if (result == null) {
            Object key;
            Map map;
            Class lastClass = (Class)context.get("last.bean.accessed");
            String lastProperty = (String)context.get("last.property.accessed");
            if (lastClass == null || lastProperty == null) {
                return super.getProperty(context, target, name);
            }
            Class keyClass = _converter.getObjectTypeDeterminer().getKeyClass(lastClass, lastProperty);
            if (keyClass == null) {
                Class clazz = keyClass = String.class;
            }
            if ((result = (map = (Map)target).get(key = this.getKey(context, name))) == null && context.get("xwork.NullHandler.createNullObjects") != null && XWorkConverter.getInstance().getObjectTypeDeterminer().shouldCreateIfNew(lastClass, lastProperty, target, null, false)) {
                Class valueClass = _converter.getObjectTypeDeterminer().getElementClass(lastClass, lastProperty, key);
                try {
                    result = ObjectFactory.getObjectFactory().buildBean(valueClass, context);
                    map.put(key, result);
                }
                catch (Exception exc) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private boolean contains(String[] array, String name) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Entering setProperty(" + context + "," + target + "," + name + "," + value + ")"));
        }
        Object key = this.getKey(context, name);
        Map map = (Map)target;
        map.put(key, this.getValue(context, value));
    }

    private Object getValue(Map context, Object value) {
        Class lastClass = (Class)context.get("last.bean.accessed");
        String lastProperty = (String)context.get("last.property.accessed");
        if (lastClass == null || lastProperty == null) {
            return value;
        }
        Class elementClass = _converter.getObjectTypeDeterminer().getElementClass(lastClass, lastProperty, null);
        if (elementClass == null) {
            return value;
        }
        return _converter.convertValue(context, value, elementClass);
    }

    private Object getKey(Map context, Object name) {
        Class lastClass = (Class)context.get("last.bean.accessed");
        String lastProperty = (String)context.get("last.property.accessed");
        if (lastClass == null || lastProperty == null) {
            return name;
        }
        Class keyClass = _converter.getObjectTypeDeterminer().getKeyClass(lastClass, lastProperty);
        if (keyClass == null) {
            keyClass = String.class;
        }
        return _converter.convertValue(context, name, keyClass);
    }
}

