/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork;

import com.opensymphony.xwork.util.location.Locatable;
import com.opensymphony.xwork.util.location.Location;
import com.opensymphony.xwork.util.location.LocationUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class XworkException
extends RuntimeException
implements Locatable {
    private Location location;

    public XworkException() {
    }

    public XworkException(String s) {
        this(s, null, null);
    }

    public XworkException(String s, Object target) {
        this(s, null, target);
    }

    public XworkException(Throwable cause) {
        this(null, cause, null);
    }

    public XworkException(Throwable cause, Object target) {
        this(null, cause, target);
    }

    public XworkException(String s, Throwable cause) {
        this(s, cause, null);
    }

    public XworkException(String s, Throwable cause, Object target) {
        super(s, cause);
        this.location = LocationUtils.getLocation(target);
        if (this.location == Location.UNKNOWN) {
            this.location = LocationUtils.getLocation(cause);
        }
    }

    public Throwable getThrowable() {
        return this.getCause();
    }

    public Location getLocation() {
        return this.location;
    }

    public List getSnippet() {
        return this.getSnippet(2);
    }

    public List getSnippet(int padding) {
        ArrayList<String> snippet = new ArrayList<String>();
        if (this.location != null && this.location.getLineNumber() > 0) {
            try {
                String line;
                InputStream in = new URL(this.location.getURI()).openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                int lineno = 0;
                int errno = this.location.getLineNumber();
                while ((line = reader.readLine()) != null) {
                    if (++lineno < errno - padding || lineno > errno + padding) continue;
                    snippet.add(line);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return snippet;
    }

    public String toString() {
        String msg = this.getMessage();
        if (msg == null && this.getCause() != null) {
            msg = this.getCause().getMessage();
        }
        if (this.location != null) {
            if (msg != null) {
                return msg + " - " + this.location.toString();
            }
            return this.location.toString();
        }
        return msg;
    }
}

