/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.util;

import com.opensymphony.util.FileManager;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.util.CompoundRoot;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.XWorkBasicConverter;
import java.io.InputStream;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import ognl.DefaultTypeConverter;
import ognl.Evaluation;
import ognl.OgnlContext;
import ognl.TypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XWorkConverter
extends DefaultTypeConverter {
    private static XWorkConverter instance;
    private static final Log LOG;
    public static final String REPORT_CONVERSION_ERRORS = "report.conversion.errors";
    public static final String CONVERSION_PROPERTY_FULLNAME = "conversion.property.fullName";
    public static final String CONVERSION_ERROR_PROPERTY_PREFIX = "invalid.fieldvalue.";
    public static final String CONVERSION_COLLECTION_PREFIX = "Collection_";
    HashMap defaultMappings = new HashMap();
    HashMap mappings = new HashMap();
    HashSet noMapping = new HashSet();
    HashSet unknownMappings = new HashSet();
    TypeConverter defaultTypeConverter = new XWorkBasicConverter();

    private XWorkConverter() {
        try {
            this.loadConversionProps("xwork-default-conversion.properties");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.loadConversionProps("xwork-conversion.properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getConversionErrorMessage(String propertyName, OgnlValueStack stack) {
        String defaultMessage = LocalizedTextUtil.findDefaultText("xwork.default.invalid.fieldvalue", ActionContext.getContext().getLocale(), new Object[]{propertyName});
        String getTextExpression = "getText('invalid.fieldvalue." + propertyName + "','" + defaultMessage + "')";
        String message = (String)stack.findValue(getTextExpression);
        if (message == null) {
            message = defaultMessage;
        }
        return message;
    }

    public static XWorkConverter getInstance() {
        if (instance == null) {
            instance = new XWorkConverter();
        }
        return instance;
    }

    public static String buildConverterFilename(Class clazz) {
        String className = clazz.getName();
        String resource = className.replace('.', '/') + "-conversion.properties";
        return resource;
    }

    public static void resetInstance() {
        instance = null;
    }

    public void setDefaultConverter(TypeConverter defaultTypeConverter) {
        this.defaultTypeConverter = defaultTypeConverter;
    }

    public Object convertValue(Map context, Object target, Member member, String property, Object value, Class toClass) {
        TypeConverter tc = null;
        if (target != null) {
            Class clazz = target.getClass();
            Object[] classProp = null;
            if (target instanceof CompoundRoot && context != null) {
                classProp = this.getClassProperty(context);
            }
            if (classProp != null) {
                clazz = (Class)classProp[0];
                property = (String)classProp[1];
            }
            tc = (TypeConverter)this.getConverter(clazz, property);
        }
        if (tc == null) {
            tc = toClass.equals(String.class) && value != null && !value.getClass().equals(String.class) && !value.getClass().equals(String[].class) ? this.lookup(value.getClass()) : this.lookup(toClass);
        }
        if (tc != null) {
            try {
                return tc.convertValue(context, target, member, property, value, toClass);
            }
            catch (Exception e) {
                this.handleConversionException(context, property, value, target);
                return this.acceptableErrorValue(toClass);
            }
        }
        if (this.defaultTypeConverter != null) {
            try {
                return this.defaultTypeConverter.convertValue(context, target, member, property, value, toClass);
            }
            catch (Exception e) {
                this.handleConversionException(context, property, value, target);
                return this.acceptableErrorValue(toClass);
            }
        }
        try {
            return super.convertValue(context, target, member, property, value, toClass);
        }
        catch (Exception e) {
            this.handleConversionException(context, property, value, target);
            return this.acceptableErrorValue(toClass);
        }
    }

    public TypeConverter lookup(String className) {
        if (this.unknownMappings.contains(className)) {
            return null;
        }
        TypeConverter result = (TypeConverter)this.defaultMappings.get(className);
        if (result == null) {
            Class<?> clazz = null;
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            result = this.lookupSuper(clazz);
            if (result != null) {
                this.registerConverter(className, result);
            } else {
                this.registerConverterNotFound(className);
            }
        }
        return result;
    }

    public TypeConverter lookup(Class clazz) {
        return this.lookup(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getConverter(Class clazz, String property) {
        String string = clazz.toString().intern();
        synchronized (string) {
            if (property != null && !this.noMapping.contains(clazz)) {
                try {
                    Map mapping = (Map)this.mappings.get(clazz);
                    mapping = mapping == null ? this.buildConverterMapping(clazz) : this.conditionalReload(clazz, mapping);
                    return mapping.get(property);
                }
                catch (Throwable t) {
                    this.noMapping.add(clazz);
                }
            }
        }
        return null;
    }

    protected void handleConversionException(Map context, String property, Object value, Object object) {
        if (context.get(REPORT_CONVERSION_ERRORS) == Boolean.TRUE) {
            HashMap<String, Object> conversionErrors;
            String realProperty = property;
            String fullName = (String)context.get(CONVERSION_PROPERTY_FULLNAME);
            if (fullName != null) {
                realProperty = fullName;
            }
            if ((conversionErrors = (HashMap<String, Object>)context.get("com.opensymphony.xwork.ActionContext.conversionErrors")) == null) {
                conversionErrors = new HashMap<String, Object>();
                context.put("com.opensymphony.xwork.ActionContext.conversionErrors", conversionErrors);
            }
            conversionErrors.put(realProperty, value);
        }
    }

    protected synchronized void registerConverter(String className, TypeConverter converter) {
        this.defaultMappings.put(className, converter);
    }

    protected synchronized void registerConverterNotFound(String className) {
        this.unknownMappings.add(className);
    }

    private Object[] getClassProperty(Map context) {
        Object[] classProp = null;
        OgnlContext ognlContext = (OgnlContext)context;
        Evaluation eval = ognlContext.getCurrentEvaluation();
        if (eval == null) {
            eval = ognlContext.getLastEvaluation();
        }
        if (eval != null && eval.getLastChild() != null) {
            classProp = new Object[2];
            classProp[0] = eval.getLastChild().getLastChild() != null && eval.getLastChild().getLastChild().getSource() != null && eval.getLastChild().getLastChild().getSource().getClass() != CompoundRoot.class ? eval.getLastChild().getLastChild().getSource().getClass() : eval.getLastChild().getSource().getClass();
            String property = eval.getNode().jjtGetChild(eval.getNode().jjtGetNumChildren() - 1).toString();
            if (property.startsWith("\"") && property.endsWith("\"")) {
                property = property.substring(1, property.length() - 1);
            }
            classProp[1] = property;
        }
        return classProp;
    }

    private Object acceptableErrorValue(Class toClass) {
        if (!toClass.isPrimitive()) {
            return null;
        }
        if (toClass == Integer.TYPE) {
            return new Integer(0);
        }
        if (toClass == Double.TYPE) {
            return new Double(0.0);
        }
        if (toClass == Long.TYPE) {
            return new Long(0L);
        }
        if (toClass == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (toClass == Short.TYPE) {
            return new Short(0);
        }
        if (toClass == Float.TYPE) {
            return new Float(0.0f);
        }
        if (toClass == Byte.TYPE) {
            return new Byte(0);
        }
        if (toClass == Character.TYPE) {
            return new Character('\u0000');
        }
        return null;
    }

    private void addConverterMapping(Map mapping, Class clazz) {
        try {
            InputStream is = FileManager.loadFile((String)XWorkConverter.buildConverterFilename(clazz), (Class)clazz);
            if (is != null) {
                Map.Entry<Object, Object> entry;
                String key;
                Properties prop = new Properties();
                prop.load(is);
                Iterator<Map.Entry<Object, Object>> it = prop.entrySet().iterator();
                while (it.hasNext() && !mapping.containsKey(key = (String)(entry = it.next()).getKey())) {
                    if (!key.startsWith(CONVERSION_COLLECTION_PREFIX)) {
                        mapping.put(key, this.createTypeConverter((String)entry.getValue()));
                        continue;
                    }
                    mapping.put(key, Thread.currentThread().getContextClassLoader().loadClass((String)entry.getValue()));
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Problem loading properties for " + clazz.getName()), (Throwable)ex);
        }
    }

    private Map buildConverterMapping(Class clazz) throws Exception {
        HashMap mapping = new HashMap();
        Class curClazz = clazz;
        while (!curClazz.equals(Object.class)) {
            this.addConverterMapping(mapping, curClazz);
            Class<?>[] interfaces = curClazz.getInterfaces();
            for (int x = 0; x < interfaces.length; ++x) {
                this.addConverterMapping(mapping, interfaces[x]);
            }
            curClazz = curClazz.getSuperclass();
        }
        if (mapping.size() > 0) {
            this.mappings.put(clazz, mapping);
        } else {
            this.noMapping.add(clazz);
        }
        return mapping;
    }

    private Map conditionalReload(Class clazz, Map oldValues) throws Exception {
        Map mapping = oldValues;
        if (FileManager.isReloadingConfigs() && FileManager.fileNeedsReloading((String)XWorkConverter.buildConverterFilename(clazz))) {
            mapping = this.buildConverterMapping(clazz);
        }
        return mapping;
    }

    private TypeConverter createTypeConverter(String className) throws Exception {
        Class<?> conversionClass = Thread.currentThread().getContextClassLoader().loadClass(className);
        return (TypeConverter)ObjectFactory.getObjectFactory().buildBean(conversionClass);
    }

    private void loadConversionProps(String propsName) throws Exception {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(propsName);
        Properties props = new Properties();
        props.load(is);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            try {
                this.defaultMappings.put(key, this.createTypeConverter((String)entry.getValue()));
            }
            catch (Exception e) {
                LOG.error((Object)"Conversion registration error", (Throwable)e);
            }
        }
    }

    private TypeConverter lookupSuper(Class clazz) {
        TypeConverter result = null;
        if (clazz != null && (result = (TypeConverter)this.defaultMappings.get(clazz.getName())) == null) {
            int i = 0;
            Class<?>[] interfaces = clazz.getInterfaces();
            if (i < interfaces.length && this.defaultMappings.containsKey(interfaces[i].getName())) {
                result = (TypeConverter)this.defaultMappings.get(interfaces[i].getName());
            }
            if (result == null) {
                result = this.lookupSuper(clazz.getSuperclass());
            }
        }
        return result;
    }

    static {
        LOG = LogFactory.getLog(XWorkConverter.class);
    }
}

