/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork;

import com.opensymphony.xwork.LocaleProvider;
import com.opensymphony.xwork.TextProvider;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class TextProviderSupport
implements TextProvider {
    private Class clazz;
    private LocaleProvider localeProvider;
    private ResourceBundle bundle;

    public TextProviderSupport(Class clazz, LocaleProvider provider) {
        this.clazz = clazz;
        this.localeProvider = provider;
    }

    public TextProviderSupport(ResourceBundle bundle, LocaleProvider provider) {
        this.bundle = bundle;
        this.localeProvider = provider;
    }

    public String getText(String aTextName) {
        if (this.clazz != null) {
            return LocalizedTextUtil.findText(this.clazz, aTextName, this.getLocale());
        }
        return LocalizedTextUtil.findText(this.bundle, aTextName, this.getLocale());
    }

    public String getText(String aTextName, String defaultValue) {
        if (this.clazz != null) {
            return LocalizedTextUtil.findText(this.clazz, aTextName, this.getLocale(), defaultValue, new Object[0]);
        }
        return LocalizedTextUtil.findText(this.bundle, aTextName, this.getLocale(), defaultValue, new Object[0]);
    }

    public String getText(String aTextName, List args) {
        if (this.clazz != null) {
            return LocalizedTextUtil.findText(this.clazz, aTextName, this.getLocale(), aTextName, args.toArray());
        }
        return LocalizedTextUtil.findText(this.bundle, aTextName, this.getLocale(), aTextName, args.toArray());
    }

    public String getText(String aTextName, String defaultValue, List args) {
        Object[] argsArray;
        Object[] objectArray = argsArray = args != null ? args.toArray() : null;
        if (this.clazz != null) {
            return LocalizedTextUtil.findText(this.clazz, aTextName, this.getLocale(), defaultValue, argsArray);
        }
        return LocalizedTextUtil.findText(this.bundle, aTextName, this.getLocale(), defaultValue, argsArray);
    }

    public ResourceBundle getTexts(String aBundleName) {
        return LocalizedTextUtil.findResourceBundle(aBundleName, this.getLocale());
    }

    public ResourceBundle getTexts() {
        return this.getTexts(this.clazz.getName());
    }

    private Locale getLocale() {
        return this.localeProvider.getLocale();
    }
}

