/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.xslt;

import com.opensymphony.webwork.WebWorkException;
import com.opensymphony.webwork.views.xslt.AdapterFactory;
import com.opensymphony.webwork.views.xslt.AdapterNode;
import com.opensymphony.webwork.views.xslt.SimpleNodeList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class AbstractAdapterNode
implements AdapterNode {
    private static final NamedNodeMap EMPTY_NAMEDNODEMAP = new NamedNodeMap(){

        public int getLength() {
            return 0;
        }

        public Node item(int index) {
            return null;
        }

        public Node getNamedItem(String name) {
            return null;
        }

        public Node removeNamedItem(String name) throws DOMException {
            return null;
        }

        public Node setNamedItem(Node arg) throws DOMException {
            return null;
        }

        public Node setNamedItemNS(Node arg) throws DOMException {
            return null;
        }

        public Node getNamedItemNS(String namespaceURI, String localName) {
            return null;
        }

        public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
            return null;
        }
    };
    private List childAdapters;
    private Log log = LogFactory.getLog(this.getClass());
    private Object propertyValue;
    private String propertyName;
    private AdapterNode parent;
    private AdapterFactory adapterFactory;

    public AbstractAdapterNode() {
        if (LogFactory.getLog(this.getClass()).isDebugEnabled()) {
            LogFactory.getLog(this.getClass()).debug((Object)("Creating " + this));
        }
    }

    protected void setContext(AdapterFactory adapterFactory, AdapterNode parent, String propertyName, Object value) {
        this.setAdapterFactory(adapterFactory);
        this.setParent(parent);
        this.setPropertyName(propertyName);
        this.setPropertyValue(value);
    }

    protected List buildChildAdapters() {
        return new ArrayList();
    }

    protected List getChildAdapters() {
        if (this.childAdapters == null) {
            this.childAdapters = this.buildChildAdapters();
        }
        return this.childAdapters;
    }

    public Node getChildBeforeOrAfter(Node child, boolean before) {
        this.log.debug((Object)"getChildBeforeOrAfter: ");
        List adapters = this.getChildAdapters();
        this.log.debug((Object)("childAdapters = " + adapters));
        this.log.debug((Object)("child = " + child));
        int index = adapters.indexOf(child);
        if (index < 0) {
            throw new WebWorkException(child + " is no child of " + this);
        }
        int siblingIndex = before ? index - 1 : index + 1;
        return 0 < siblingIndex && siblingIndex < adapters.size() ? (Node)adapters.get(siblingIndex) : null;
    }

    public Node getChildAfter(Node child) {
        this.log.trace((Object)"getChildafter");
        return this.getChildBeforeOrAfter(child, false);
    }

    public Node getChildBefore(Node child) {
        this.log.trace((Object)"getchildbefore");
        return this.getChildBeforeOrAfter(child, true);
    }

    public NodeList getElementsByTagName(String tagName) {
        if (tagName.equals("*")) {
            return this.getChildNodes();
        }
        LinkedList<Node> filteredChildren = new LinkedList<Node>();
        for (Node adapterNode : this.getChildAdapters()) {
            if (!adapterNode.getNodeName().equals(tagName)) continue;
            filteredChildren.add(adapterNode);
        }
        return new SimpleNodeList(filteredChildren);
    }

    public NodeList getElementsByTagNameNS(String string, String string1) {
        return null;
    }

    public NamedNodeMap getAttributes() {
        return EMPTY_NAMEDNODEMAP;
    }

    public NodeList getChildNodes() {
        SimpleNodeList nl = new SimpleNodeList(this.getChildAdapters());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getChildNodes for tag: " + this.getNodeName() + " num children: " + nl.getLength()));
        }
        return nl;
    }

    public Node getFirstChild() {
        return this.getChildNodes().getLength() > 0 ? this.getChildNodes().item(0) : null;
    }

    public Node getLastChild() {
        return this.getChildNodes().getLength() > 0 ? this.getChildNodes().item(this.getChildNodes().getLength() - 1) : null;
    }

    public String getLocalName() {
        return null;
    }

    public String getNamespaceURI() {
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
        throw this.operationNotSupported();
    }

    public String getNodeValue() throws DOMException {
        throw this.operationNotSupported();
    }

    public Document getOwnerDocument() {
        return null;
    }

    public Node getParentNode() {
        this.log.trace((Object)"getParentNode");
        return this.getParent();
    }

    public AdapterNode getParent() {
        return this.parent;
    }

    public void setParent(AdapterNode parent) {
        this.parent = parent;
    }

    public Object getPropertyValue() {
        return this.propertyValue;
    }

    public void setPropertyValue(Object prop) {
        this.propertyValue = prop;
    }

    public void setPrefix(String string) throws DOMException {
        throw this.operationNotSupported();
    }

    public String getPrefix() {
        return null;
    }

    public Node getNextSibling() {
        Node next = this.getParent().getChildAfter(this);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("getNextSibling on " + this.getNodeName() + ": " + (next == null ? "null" : next.getNodeName())));
        }
        return this.getParent().getChildAfter(this);
    }

    public Node getPreviousSibling() {
        return this.getParent().getChildBefore(this);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String name) {
        this.propertyName = name;
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public boolean isSupported(String string, String string1) {
        throw this.operationNotSupported();
    }

    public Node appendChild(Node node) throws DOMException {
        throw this.operationNotSupported();
    }

    public Node cloneNode(boolean b) {
        this.log.trace((Object)"cloneNode");
        throw this.operationNotSupported();
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public Node insertBefore(Node node, Node node1) throws DOMException {
        throw this.operationNotSupported();
    }

    public void normalize() {
        this.log.trace((Object)"normalize");
        throw this.operationNotSupported();
    }

    public Node removeChild(Node node) throws DOMException {
        throw this.operationNotSupported();
    }

    public Node replaceChild(Node node, Node node1) throws DOMException {
        throw this.operationNotSupported();
    }

    public boolean isDefaultNamespace(String string) {
        throw this.operationNotSupported();
    }

    public String lookupNamespaceURI(String string) {
        throw this.operationNotSupported();
    }

    public String getNodeName() {
        throw this.operationNotSupported();
    }

    public short getNodeType() {
        throw this.operationNotSupported();
    }

    public String getBaseURI() {
        throw this.operationNotSupported();
    }

    public short compareDocumentPosition(Node node) throws DOMException {
        throw this.operationNotSupported();
    }

    public String getTextContent() throws DOMException {
        throw this.operationNotSupported();
    }

    public void setTextContent(String string) throws DOMException {
        throw this.operationNotSupported();
    }

    public boolean isSameNode(Node node) {
        throw this.operationNotSupported();
    }

    public String lookupPrefix(String string) {
        throw this.operationNotSupported();
    }

    public boolean isEqualNode(Node node) {
        throw this.operationNotSupported();
    }

    public Object getFeature(String string, String string1) {
        throw this.operationNotSupported();
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        throw this.operationNotSupported();
    }

    public Object getUserData(String string) {
        throw this.operationNotSupported();
    }

    protected WebWorkException operationNotSupported() {
        return new WebWorkException("Operation not supported.");
    }

    public String toString() {
        return this.getClass() + ": " + this.getNodeName() + " parent=" + this.getParentNode();
    }
}

