/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.spring.lifecycle;

import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class ApplicationContextSessionListener
implements HttpSessionListener,
Serializable {
    public static final String SESSION_CONTEXT_CLASS_PARAM = "sessionContextClass";
    public static final Class DEFAULT_SESSION_CONTEXT_CLASS = XmlWebApplicationContext.class;
    public static final String SESSION_CONFIG_LOCATION_PARAM = "sessionContextConfigLocation";
    public static final String APP_CONTEXT_SESSION_KEY = "com.opensymphony.webwork.spring.ApplicationContextSessionListener_APP_CONTEXT";
    public static final String[] DEFAULT_SESSION_CONFIG = new String[]{"classpath:session.xml"};
    private ConfigurableWebApplicationContext sessionContext;

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        HttpSession session = httpSessionEvent.getSession();
        ServletContext servletContext = session.getServletContext();
        WebApplicationContext appContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        String contextClassName = servletContext.getInitParameter(SESSION_CONTEXT_CLASS_PARAM);
        Class<?> contextClass = DEFAULT_SESSION_CONTEXT_CLASS;
        if (contextClassName != null) {
            try {
                contextClass = Class.forName(contextClassName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException ex) {
                throw new ApplicationContextException("Failed to load context class [" + contextClassName + "]", (Throwable)ex);
            }
            if (!ConfigurableWebApplicationContext.class.isAssignableFrom(contextClass)) {
                throw new ApplicationContextException("Custom context class [" + contextClassName + "] is not of type ConfigurableWebApplicationContext");
            }
        }
        this.sessionContext = (ConfigurableWebApplicationContext)BeanUtils.instantiateClass((Class)contextClass);
        this.sessionContext.setParent((ApplicationContext)appContext);
        this.sessionContext.setServletContext(servletContext);
        String configLocation = servletContext.getInitParameter(SESSION_CONFIG_LOCATION_PARAM);
        if (configLocation != null) {
            this.sessionContext.setConfigLocations(StringUtils.tokenizeToStringArray((String)configLocation, (String)",; \t\n"));
        } else {
            this.sessionContext.setConfigLocations(DEFAULT_SESSION_CONFIG);
        }
        this.sessionContext.refresh();
        session.setAttribute(APP_CONTEXT_SESSION_KEY, (Object)this.sessionContext);
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        this.sessionContext.close();
        this.sessionContext = null;
    }
}

