/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.sitemesh;

import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.filter.PageFilter;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.dispatcher.DispatcherUtils;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.ActionSupport;
import com.opensymphony.xwork.Result;
import com.opensymphony.xwork.interceptor.PreResultListener;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.IOException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class TemplatePageFilter
extends PageFilter {
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this.filterConfig = filterConfig;
    }

    protected abstract void applyDecorator(Page var1, Decorator var2, HttpServletRequest var3, HttpServletResponse var4, ServletContext var5, ActionContext var6) throws ServletException, IOException;

    protected void applyDecorator(Page page, Decorator decorator, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletContext servletContext = this.filterConfig.getServletContext();
        ActionContext ctx = ServletActionContext.getActionContext(req);
        if (ctx == null) {
            OgnlValueStack vs = new OgnlValueStack();
            vs.getContext().putAll(DispatcherUtils.getInstance().createContextMap(req, res, null, servletContext));
            ctx = new ActionContext(vs.getContext());
            if (ctx.getActionInvocation() == null) {
                ActionSupport action = new ActionSupport();
                vs.push((Object)action);
                ctx.setActionInvocation((ActionInvocation)new DummyActionInvocation(action));
            }
        }
        this.applyDecorator(page, decorator, req, res, servletContext, ctx);
    }

    protected String getEncoding() {
        String encoding = (String)Configuration.get("webwork.i18n.encoding");
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    static class DummyActionInvocation
    implements ActionInvocation {
        ActionSupport action;

        public DummyActionInvocation(ActionSupport action) {
            this.action = action;
        }

        public Object getAction() {
            return this.action;
        }

        public boolean isExecuted() {
            return false;
        }

        public ActionContext getInvocationContext() {
            return null;
        }

        public ActionProxy getProxy() {
            return null;
        }

        public Result getResult() throws Exception {
            return null;
        }

        public String getResultCode() {
            return null;
        }

        public void setResultCode(String resultCode) {
        }

        public OgnlValueStack getStack() {
            return null;
        }

        public void addPreResultListener(PreResultListener listener) {
        }

        public String invoke() throws Exception {
            return null;
        }

        public String invokeActionOnly() throws Exception {
            return null;
        }
    }
}

