/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.quickstart;

import com.opensymphony.webwork.quickstart.MultiWebApplicationContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.mortbay.util.Resource;

public class MultiDirResource
extends Resource {
    MultiWebApplicationContext ctx;
    File[] files;
    String uri;

    public MultiDirResource(MultiWebApplicationContext ctx, String uri, List pathPriority, Map paths) {
        this.ctx = ctx;
        this.uri = uri;
        ArrayList<File> files = new ArrayList<File>();
        for (String path : pathPriority) {
            List dirs = (List)paths.get(path);
            if (!uri.startsWith(path) && (!uri.equals("") || !path.equals("/"))) continue;
            for (String s : dirs) {
                if (uri.startsWith(path)) {
                    files.add(new File(s, uri.substring(path.length())));
                    continue;
                }
                files.add(new File(s, uri));
            }
        }
        this.files = files.toArray(new File[files.size()]);
    }

    public void release() {
    }

    public boolean exists() {
        for (int i = 0; i < this.files.length; ++i) {
            File file = this.files[i];
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    public boolean isDirectory() {
        for (int i = 0; i < this.files.length; ++i) {
            File file = this.files[i];
            if (!file.exists()) continue;
            return file.isDirectory();
        }
        return false;
    }

    public long lastModified() {
        for (int i = 0; i < this.files.length; ++i) {
            File file = this.files[i];
            if (!file.exists()) continue;
            return file.lastModified();
        }
        return 0L;
    }

    public long length() {
        for (int i = 0; i < this.files.length; ++i) {
            File file = this.files[i];
            if (!file.exists()) continue;
            return file.length();
        }
        return 0L;
    }

    public URL getURL() {
        for (int i = 0; i < this.files.length; ++i) {
            File file = this.files[i];
            if (!file.exists()) continue;
            try {
                return file.toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public File getFile() throws IOException {
        for (int i = 0; i < this.files.length; ++i) {
            File file = this.files[i];
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public String getName() {
        for (int i = 0; i < this.files.length; ++i) {
            File file = this.files[i];
            if (!file.exists()) continue;
            return file.getName();
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        for (int i = 0; i < this.files.length; ++i) {
            File file = this.files[i];
            if (!file.exists()) continue;
            return new FileInputStream(file);
        }
        return null;
    }

    public OutputStream getOutputStream() throws IOException, SecurityException {
        for (int i = 0; i < this.files.length; ++i) {
            File file = this.files[i];
            if (!file.exists()) continue;
            return new FileOutputStream(file);
        }
        return null;
    }

    public boolean delete() throws SecurityException {
        for (int i = 0; i < this.files.length; ++i) {
            File file = this.files[i];
            if (!file.exists()) continue;
            return file.delete();
        }
        return false;
    }

    public boolean renameTo(Resource resource) throws SecurityException {
        return false;
    }

    public String[] list() {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < this.files.length; ++i) {
            File file = this.files[i];
            if (!file.exists()) continue;
            String[] files = file.list();
            for (int j = 0; j < files.length; ++j) {
                String s = files[j];
                set.add(s);
            }
        }
        return set.toArray(new String[set.size()]);
    }

    public Resource addPath(String string) throws IOException, MalformedURLException {
        return this.ctx.newResolver(this.uri + string);
    }
}

