/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.quickstart;

import com.opensymphony.webwork.quickstart.Mapping;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.collections.MultiHashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Configuration
implements Serializable {
    String ideaConfig;
    String extendsConfig;
    String resolver;
    Integer port;
    String context;
    List libs;
    List classDirs;
    List sources;
    List webDirs;
    Map mappings;
    List pathPriority;

    public String getIdeaConfig() {
        return this.ideaConfig;
    }

    public void setIdeaConfig(String ideaConfig) {
        this.ideaConfig = ideaConfig;
    }

    public String getExtendsConfig() {
        return this.extendsConfig;
    }

    public void setExtendsConfig(String extendsConfig) {
        this.extendsConfig = extendsConfig;
    }

    public String getResolver() {
        return this.resolver;
    }

    public void setResolver(String resolver) {
        this.resolver = resolver;
    }

    public List getLibs() {
        return this.libs;
    }

    public void setLibs(List libs) {
        this.libs = libs;
    }

    public List getClassDirs() {
        return this.classDirs;
    }

    public void setClassDirs(List classDirs) {
        this.classDirs = classDirs;
    }

    public List getSources() {
        return this.sources;
    }

    public void setSources(List sources) {
        this.sources = sources;
    }

    public Map getMappings() {
        return this.mappings;
    }

    public List getPathPriority() {
        return this.pathPriority;
    }

    public List getWebDirs() {
        return this.webDirs;
    }

    public void setWebDirs(List webDirs) {
        this.webDirs = webDirs;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void resolveDirs(String wd) {
        if (this.ideaConfig != null) {
            String full = this.resolveDir(this.ideaConfig, wd);
            try {
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = db.parse(full);
                NodeList components = doc.getElementsByTagName("root");
                ArrayList<String> jars = new ArrayList<String>();
                for (int i = 0; i < components.getLength(); ++i) {
                    Element e = (Element)components.item(i);
                    String value = e.getAttribute("url");
                    if (value == null || !value.startsWith("jar://") || !value.endsWith(".jar!/")) continue;
                    if ((value = value.substring(6, value.length() - 2)).startsWith("$MODULE_DIR$")) {
                        value = value.substring(13);
                    }
                    jars.add(value);
                }
                if (this.libs != null) {
                    this.libs.addAll(jars);
                } else {
                    this.libs = jars;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.resolve(this.libs, wd);
        this.resolve(this.classDirs, wd);
        this.resolve(this.sources, wd);
        for (Mapping mapping : this.webDirs) {
            String path = mapping.getPath();
            String dir = mapping.getDir();
            File classDir = new File(dir = this.resolveDir(dir, wd), "WEB-INF/classes");
            if (classDir.exists()) {
                String fullClassDir = this.getFullPath(classDir);
                if (this.classDirs == null) {
                    this.classDirs = new ArrayList();
                }
                if (!this.classDirs.contains(fullClassDir)) {
                    this.classDirs.add(0, fullClassDir);
                }
            }
            if (this.mappings == null) {
                this.mappings = new MultiHashMap();
                this.pathPriority = new ArrayList();
            }
            if (!this.pathPriority.contains(path)) {
                this.pathPriority.add(path);
            }
            this.mappings.put(path, dir);
        }
    }

    private void resolve(List list, String wd) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String s = (String)list.get(i);
                list.set(i, this.resolveDir(s, wd));
            }
        }
    }

    private String resolveDir(String dir, String wd) {
        File file = new File(wd, dir);
        if (!file.exists() && new File(dir).exists()) {
            file = new File(dir);
        }
        return this.getFullPath(file);
    }

    private String getFullPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public void resolveExtensions(String wd, XStream xstream) throws FileNotFoundException {
        if (this.extendsConfig != null) {
            File config = new File(wd, this.extendsConfig);
            Configuration c = (Configuration)xstream.fromXML((Reader)new FileReader(config));
            c.resolveDirs(config.getParent());
            c.resolveExtensions(config.getParent(), xstream);
            if (c.getResolver() != null) {
                this.resolver = c.getResolver();
            }
            if (this.port == null) {
                this.port = c.getPort();
            }
            if (c.getContext() != null) {
                this.context = c.getContext();
            }
            if (c.getLibs() != null) {
                if (this.libs != null) {
                    this.libs.addAll(c.getLibs());
                } else {
                    this.libs = c.getLibs();
                }
            }
            if (c.getClassDirs() != null) {
                if (this.classDirs != null) {
                    this.classDirs.addAll(c.getClassDirs());
                } else {
                    this.classDirs = c.getClassDirs();
                }
            }
            if (c.getSources() != null) {
                if (this.sources != null) {
                    this.sources.addAll(c.getSources());
                } else {
                    this.sources = c.getSources();
                }
            }
            for (Map.Entry entry : c.getMappings().entrySet()) {
                List list = (List)this.mappings.get(entry.getKey());
                if (list != null) {
                    list.addAll((List)entry.getValue());
                    continue;
                }
                this.mappings.put(entry.getKey(), (List)entry.getValue());
            }
            for (String path : c.getPathPriority()) {
                if (this.pathPriority.contains(path)) continue;
                this.pathPriority.add(path);
            }
        }
    }

    public boolean validate() {
        boolean error = false;
        if (this.port == null) {
            System.out.println("Port must be greater than 0");
            error = true;
        }
        if (!this.context.startsWith("/")) {
            System.out.println("Context must start with /");
            error = true;
        }
        if (this.verifyList("Library", this.libs, false)) {
            error = true;
        }
        if (this.verifyList("ClassDir", this.classDirs, false)) {
            error = true;
        }
        if (this.verifyList("Sources", this.sources, true)) {
            error = true;
        }
        if (this.verifyMap("WebApp", this.mappings)) {
            error = true;
        }
        return error;
    }

    private boolean verifyMap(String name, Map map) {
        boolean error = false;
        if (map == null || map.size() == 0) {
            System.out.println(name + " must be specified");
            return true;
        }
        for (Map.Entry entry : map.entrySet()) {
            List list = (List)entry.getValue();
            this.verifyList(name, list, false);
        }
        return error;
    }

    private boolean verifyList(String name, List list, boolean allowEmpty) {
        boolean error = false;
        if (!(allowEmpty || list != null && list.size() != 0)) {
            System.out.println(name + " must be specified");
            return true;
        }
        if (list != null) {
            for (String s : list) {
                if (new File(s).exists()) continue;
                System.out.println(name + " doesn't exist: " + s);
                error = true;
            }
        }
        return error;
    }
}

