/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.jsp.ui.table;

import com.opensymphony.webwork.views.jsp.ui.ComponentTag;
import com.opensymphony.webwork.views.jsp.ui.table.SortFilterModel;
import com.opensymphony.webwork.views.jsp.ui.table.SortableTableModel;
import com.opensymphony.webwork.views.jsp.ui.table.WebTableColumn;
import com.opensymphony.webwork.views.jsp.ui.table.renderer.CellRenderer;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.util.OgnlUtil;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.swing.table.TableModel;
import org.apache.commons.logging.LogFactory;

public class WebTable
extends ComponentTag {
    public static final String TEMPLATE = "table";
    protected String _sortOrder = "NONE";
    protected String modelNameAttr = null;
    protected TableModel model = null;
    protected WebTableColumn[] _columns = null;
    protected boolean sortableAttr = false;
    protected int _sortColumn = -1;
    int _curRow = 0;

    public WebTable() {
    }

    public WebTable(TableModel model) {
        this.setModel(model);
    }

    public WebTableColumn getColumn(int index) {
        try {
            return this._columns[index];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getColumnCount() {
        return this._columns.length;
    }

    public void setColumnDisplayName(int column, String displayName) {
        this._columns[column].setDisplayName(displayName);
    }

    public void getColumnDisplayName(int column) {
        this._columns[column].getDisplayName();
    }

    public void setColumnHidden(int column, boolean hide) {
        this._columns[column].setHidden(hide);
    }

    public boolean isColumnHidden(int column) {
        return this._columns[column].isHidden();
    }

    public void setColumnRenderer(int column, CellRenderer renderer) {
        this._columns[column].setRenderer(renderer);
    }

    public CellRenderer getColumnRenderer(int column) {
        return this._columns[column].getRenderer();
    }

    public WebTableColumn[] getColumns() {
        return this._columns;
    }

    public String[] getFormattedRow(int row) {
        ArrayList<String> data = new ArrayList<String>(this.getNumberOfVisibleColumns());
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this._columns[i].isVisible()) continue;
            data.add(this._columns[i].getRenderer().renderCell(this, this.model.getValueAt(row, i), row, i));
        }
        return data.toArray(new String[0]);
    }

    public void setModel(TableModel model) {
        this.model = model;
        this._columns = new WebTableColumn[this.model.getColumnCount()];
        for (int i = 0; i < this._columns.length; ++i) {
            this._columns[i] = new WebTableColumn(this.model.getColumnName(i), i);
        }
        if (this.sortableAttr && !(this.model instanceof SortableTableModel)) {
            this.model = new SortFilterModel(this.model);
        }
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setModelName(String modelName) {
        this.modelNameAttr = modelName;
    }

    public String getModelName() {
        return this.modelNameAttr;
    }

    public Object getRawData(int row, int column) {
        return this.model.getValueAt(row, column);
    }

    public Iterator getRawDataRowIterator() {
        return new WebTableRowIterator(this, 1);
    }

    public Object[] getRow(int row) {
        ArrayList<Object> data = new ArrayList<Object>(this.getNumberOfVisibleColumns());
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this._columns[i].isVisible()) continue;
            data.add(this.model.getValueAt(row, i));
        }
        return data.toArray(new Object[0]);
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    public Iterator getRowIterator() {
        return new WebTableRowIterator(this);
    }

    public void setSortColumn(int sortColumn) {
        this._sortColumn = sortColumn;
    }

    public int getSortColumn() {
        if (this.model instanceof SortableTableModel) {
            return ((SortableTableModel)this.model).getSortedColumnNumber();
        }
        return -1;
    }

    public String getSortColumnLinkName() {
        return "WEBTABLE_" + this.modelNameAttr + "_SORT_COLUMN";
    }

    public void setSortOrder(String sortOrder) {
        this._sortOrder = sortOrder.equals("NONE") ? "NONE" : (sortOrder.equals("DESC") ? "DESC" : (sortOrder.equals("ASC") ? "ASC" : "NONE"));
    }

    public String getSortOrder() {
        if (this.model instanceof SortableTableModel && this.getSortColumn() >= 0) {
            return ((SortableTableModel)this.model).getSortedDirection(this.getSortColumn());
        }
        return "NONE";
    }

    public String getSortOrderLinkName() {
        return "WEBTABLE_" + this.modelNameAttr + "_SORT_ORDER";
    }

    public void setSortable(boolean sortable) {
        this.sortableAttr = sortable;
        if (this.sortableAttr && this.model != null && !(this.model instanceof SortableTableModel)) {
            this.model = new SortFilterModel(this.model);
        }
    }

    public boolean isSortable() {
        return this.sortableAttr;
    }

    @Override
    public void addParameter(String name, Object value) {
        OgnlUtil.setProperty((String)name, (Object)value, (Object)this, (Map)this.getStack().getContext());
        super.addParameter(name, value);
    }

    @Override
    public int doEndTag() throws JspException {
        block12: {
            if (this.sortableAttr && this.model instanceof SortableTableModel) {
                LogFactory.getLog(this.getClass()).debug((Object)("we are looking for " + this.getSortColumnLinkName()));
                String sortColumn = this.pageContext.getRequest().getParameter(this.getSortColumnLinkName());
                String sortOrder = this.pageContext.getRequest().getParameter(this.getSortOrderLinkName());
                try {
                    block13: {
                        if (sortColumn != null || sortOrder != null) {
                            block11: {
                                if (sortColumn != null) {
                                    try {
                                        this._sortColumn = Integer.parseInt(sortColumn);
                                    }
                                    catch (Exception ex) {
                                        if (!LogFactory.getLog(this.getClass()).isDebugEnabled()) break block11;
                                        LogFactory.getLog(this.getClass()).debug((Object)"coudn't convert column, take default");
                                    }
                                }
                            }
                            if (sortOrder != null) {
                                this._sortOrder = sortOrder;
                            }
                        } else {
                            LogFactory.getLog(this.getClass()).debug((Object)"no sorting info in the request");
                        }
                        if (this._sortColumn < 0) break block12;
                        LogFactory.getLog(this.getClass()).debug((Object)("we have the sortColumn " + Integer.toString(this._sortColumn)));
                        LogFactory.getLog(this.getClass()).debug((Object)("we have the sortOrder " + this._sortOrder));
                        try {
                            ((SortableTableModel)this.model).sort(this._sortColumn, this._sortOrder);
                        }
                        catch (Exception ex) {
                            if (!LogFactory.getLog(this.getClass()).isDebugEnabled()) break block13;
                            LogFactory.getLog(this.getClass()).debug((Object)"couldn't sort the data");
                        }
                    }
                    LogFactory.getLog(this.getClass()).debug((Object)"we just sorted the data");
                }
                catch (Exception e) {
                    LogFactory.getLog(this.getClass()).error((Object)e);
                    throw new JspTagException("Error with WebTable: " + this.toString(e));
                }
            }
        }
        return super.doEndTag();
    }

    @Override
    protected String getDefaultTemplate() {
        return TEMPLATE;
    }

    protected int getNumberOfVisibleColumns() {
        int count = 0;
        for (int i = 0; i < this._columns.length; ++i) {
            if (this._columns[i].isHidden()) continue;
            ++count;
        }
        return count;
    }

    @Override
    protected void evaluateExtraParams(OgnlValueStack stack) {
        if (this.modelNameAttr != null) {
            this.modelNameAttr = (String)stack.findValue(this.modelNameAttr);
            Object obj = stack.findValue(this.modelNameAttr);
            if (obj instanceof TableModel) {
                this.setModel((TableModel)obj);
            }
        }
        Map params = this.getParameters();
        Set set = params.keySet();
        for (String key : set) {
            Object value = params.get(key);
            OgnlUtil.setProperty((String)key, value, (Object)this, (Map)ActionContext.getContext().getContextMap());
        }
        super.evaluateExtraParams(stack);
    }

    public class WebTableRowIterator
    implements Iterator {
        public static final int FORMATTED_DATA = 0;
        public static final int RAW_DATA = 1;
        protected WebTable _table;
        protected int _curRow = 0;
        protected int _mode = 0;

        protected WebTableRowIterator(WebTable table) {
            this(table, 0);
        }

        protected WebTableRowIterator(WebTable table, int mode) {
            this._table = table;
            this._mode = mode;
        }

        @Override
        public boolean hasNext() {
            if (this._table == null) {
                return false;
            }
            return this._table.getRowCount() > this._curRow;
        }

        public Object next() throws NoSuchElementException {
            if (this._table == null) {
                throw new NoSuchElementException("WebTable is null");
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException("Beyond end of WebTable");
            }
            if (this._mode == 1) {
                return this._table.getRow(this._curRow++);
            }
            return this._table.getFormattedRow(this._curRow++);
        }

        @Override
        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException("Remove not supported in WebTable");
        }
    }
}

