/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.jsp;

import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.views.jsp.PageResponse;
import com.opensymphony.webwork.views.jsp.ParamTag;
import com.opensymphony.webwork.views.jsp.WebWorkBodyTagSupport;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.LogFactory;

public class IncludeTag
extends WebWorkBodyTagSupport
implements ParamTag.Parametric {
    private static String encoding;
    private static boolean encodingDefined;
    protected Map params;
    protected String pageAttr;
    protected String valueAttr;

    public static String getContextRelativePath(ServletRequest request, String relativePath) {
        String returnValue;
        if (relativePath.startsWith("/")) {
            returnValue = relativePath;
        } else if (!(request instanceof HttpServletRequest)) {
            returnValue = relativePath;
        } else {
            HttpServletRequest hrequest = (HttpServletRequest)request;
            String uri = (String)request.getAttribute("javax.servlet.include.servlet_path");
            if (uri == null) {
                uri = hrequest.getServletPath();
            }
            returnValue = uri.substring(0, uri.lastIndexOf(47)) + '/' + relativePath;
        }
        if (returnValue.indexOf("..") != -1) {
            Stack<String> stack = new Stack<String>();
            StringTokenizer pathParts = new StringTokenizer(returnValue.replace('\\', '/'), "/");
            while (pathParts.hasMoreTokens()) {
                String part = pathParts.nextToken();
                if (part.equals(".")) continue;
                if (part.equals("..")) {
                    stack.pop();
                    continue;
                }
                stack.push(part);
            }
            StringBuffer flatPathBuffer = new StringBuffer();
            for (int i = 0; i < stack.size(); ++i) {
                flatPathBuffer.append("/" + stack.elementAt(i));
            }
            returnValue = flatPathBuffer.toString();
        }
        return returnValue;
    }

    public static void include(String aResult, PageContext aContext) throws ServletException, IOException {
        String resourcePath = IncludeTag.getContextRelativePath(aContext.getRequest(), aResult);
        RequestDispatcher rd = aContext.getRequest().getRequestDispatcher(resourcePath);
        if (rd == null) {
            throw new ServletException("Not a valid resource path:" + resourcePath);
        }
        PageResponse pageResponse = new PageResponse((HttpServletResponse)aContext.getResponse());
        rd.include((ServletRequest)((HttpServletRequest)aContext.getRequest()), (ServletResponse)pageResponse);
        String encoding = IncludeTag.getEncoding();
        if (encoding != null) {
            pageResponse.getContent().writeTo(aContext.getOut(), encoding);
        } else {
            pageResponse.getContent().writeTo(aContext.getOut(), null);
        }
    }

    public void setPage(String aPage) {
        this.pageAttr = aPage;
    }

    @Override
    public Map getParameters() {
        return this.params;
    }

    public void setValue(String aName) {
        this.valueAttr = aName;
    }

    @Override
    public void addParameter(String name, Object value) {
        if (value != null) {
            ArrayList<Object> currentValues = (ArrayList<Object>)this.params.get(name);
            if (currentValues == null) {
                currentValues = new ArrayList<Object>();
                this.params.put(name, currentValues);
            }
            currentValues.add(value);
        }
    }

    public int doEndTag() throws JspException {
        String page = this.valueAttr != null ? this.findString(this.valueAttr) : this.pageAttr;
        StringBuffer urlBuf = new StringBuffer();
        urlBuf.append(page);
        if (this.params.size() > 0) {
            urlBuf.append('?');
            String concat = "";
            for (Map.Entry entry : this.params.entrySet()) {
                Object name = entry.getKey();
                List values = (List)entry.getValue();
                for (int i = 0; i < values.size(); ++i) {
                    urlBuf.append(concat);
                    urlBuf.append(name);
                    urlBuf.append('=');
                    try {
                        urlBuf.append(URLEncoder.encode(values.get(i).toString()));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    concat = "&";
                }
            }
        }
        this.params = null;
        String result = urlBuf.toString();
        try {
            IncludeTag.include(result, this.pageContext);
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).warn((Object)("Exception thrown during include of " + result), (Throwable)e);
            throw new JspTagException(e.toString());
        }
        return 6;
    }

    public int doStartTag() throws JspException {
        this.params = new HashMap();
        return super.doStartTag();
    }

    private static String getEncoding() {
        if (encodingDefined) {
            try {
                encoding = Configuration.getString("webwork.i18n.encoding");
            }
            catch (IllegalArgumentException e) {
                encoding = System.getProperty("file.encoding");
                encodingDefined = false;
            }
        }
        return encoding;
    }

    static {
        encodingDefined = true;
    }
}

