/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher.client;

import com.opensymphony.webwork.dispatcher.client.ClientException;
import com.opensymphony.webwork.dispatcher.client.ClientRequest;
import com.opensymphony.webwork.dispatcher.client.ClientRequestInvocation;
import com.opensymphony.webwork.dispatcher.client.ClientRequestProxy;
import com.opensymphony.webwork.dispatcher.client.ProgressConsumer;
import com.opensymphony.webwork.dispatcher.client.ProgressConsumerNull;
import com.opensymphony.webwork.dispatcher.client.RemoteResult;
import com.opensymphony.webwork.dispatcher.client.TransportFactory;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.Random;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.NoOp;

public abstract class TransportFactoryBase
implements TransportFactory {
    protected String sessionId = SESSION_UNDEFINED;
    private ProgressConsumer progressConsumer = new ProgressConsumerNull();
    private Properties properties;
    private Random random = new Random();

    @Override
    public void setProperties(Properties properties) throws ClientException {
        this.properties = properties;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Object createClientRequestProxy(ClientRequest clientAction, String namespace) {
        Class<?> clazz = clientAction.getClass();
        Object enhanced = Enhancer.create(clazz, (Class[])new Class[]{ClientRequest.class}, (CallbackFilter)new CallbackFilter(){

            public int accept(Method member) {
                if (member.getName().startsWith("set") && !member.getName().startsWith("setClientRequestInvocation")) {
                    return 0;
                }
                if (member.getName().equals("execute")) {
                    return 0;
                }
                return 1;
            }
        }, (Callback[])new Callback[]{new ClientRequestProxy(), NoOp.INSTANCE});
        ClientRequest returnObject = (ClientRequest)enhanced;
        String actionName = null;
        actionName = namespace != null ? "/" + namespace + "/" + clientAction.getClass().getName() + ".action" : clientAction.getClass().getName();
        returnObject.setClientRequestInvocation(new ClientRequestInvocation(this, actionName));
        return returnObject;
    }

    @Override
    public abstract RemoteResult execute(ClientRequestInvocation var1) throws ClientException;

    @Override
    public void setProgressConsumer(ProgressConsumer progressConsumer) {
        this.progressConsumer = progressConsumer;
    }

    public ProgressConsumer getProgressConsumer() {
        return this.progressConsumer;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    public String generateRequestId() {
        return new Double(this.random.nextDouble() * 10.0).toString().replace('.', '0');
    }

    @Override
    public void resetSessionId() {
        this.sessionId = SESSION_UNDEFINED;
    }
}

