/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher;

import com.opensymphony.webwork.WebWorkStatics;
import com.opensymphony.webwork.dispatcher.ApplicationMap;
import com.opensymphony.webwork.dispatcher.ServletDispatcherResult;
import com.opensymphony.webwork.dispatcher.SessionMap;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.ActionProxyFactory;
import com.opensymphony.xwork.config.ConfigurationManager;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.ResultConfig;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilterDispatcher
implements Filter,
WebWorkStatics {
    private static final Log log = LogFactory.getLog(FilterDispatcher.class);
    private FilterConfig filterConfig;
    private Map config;

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Map namespaceAction;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        boolean invoked = false;
        if (request.getAttribute("webwork.valueStack") == null && (namespaceAction = (Map)this.config.get(request.getServletPath())) != null) {
            Map.Entry entry = namespaceAction.entrySet().iterator().next();
            String namespace = (String)entry.getKey();
            String actionName = (String)entry.getValue();
            HashMap<String, Object> extraContext = new HashMap<String, Object>();
            extraContext.put("com.opensymphony.xwork.ActionContext.parameters", request.getParameterMap());
            extraContext.put("com.opensymphony.xwork.dispatcher.HttpServletRequest", request);
            extraContext.put("com.opensymphony.xwork.dispatcher.HttpServletResponse", response);
            extraContext.put("com.opensymphony.xwork.ActionContext.session", new SessionMap(request));
            extraContext.put("com.opensymphony.xwork.ActionContext.application", new ApplicationMap(this.filterConfig.getServletContext()));
            extraContext.put("com.opensymphony.xwork.interceptor.component.ComponentManager", request.getAttribute("DefaultComponentManager"));
            try {
                ActionProxy proxy = ActionProxyFactory.getFactory().createActionProxy(namespace, actionName, extraContext);
                request.setAttribute("webwork.valueStack", (Object)proxy.getInvocation().getStack());
                proxy.execute();
            }
            catch (Exception e) {
                try {
                    response.getWriter().write("Unknown error executing action: " + e.getMessage());
                    log.error((Object)"Could not execute action", (Throwable)e);
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            invoked = true;
        }
        if (!invoked) {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        LocalizedTextUtil.addDefaultResourceBundle((String)"com/opensymphony/webwork/webwork-messages");
        Map namespaceActionConfigs = ConfigurationManager.getConfiguration().getRuntimeConfiguration().getActionConfigs();
        HashMap newConfig = new HashMap();
        for (Map.Entry entry : namespaceActionConfigs.entrySet()) {
            String namespace = (String)entry.getKey();
            Map actionConfigs = (Map)entry.getValue();
            for (Map.Entry entry2 : actionConfigs.entrySet()) {
                String actionName = (String)entry2.getKey();
                ActionConfig actionConfig = (ActionConfig)entry2.getValue();
                Map results = actionConfig.getResults();
                String view = null;
                String result = "success";
                view = this.getActionResultConfig(result, actionConfig);
                if (view == null) {
                    result = "input";
                    view = this.getActionResultConfig(result, actionConfig);
                }
                if (view == null) {
                    Map.Entry firstResult = results.entrySet().iterator().next();
                    result = (String)firstResult.getKey();
                    view = this.getActionResultConfig(result, actionConfig);
                }
                if (view == null) continue;
                HashMap<String, String> namespaceAction = new HashMap<String, String>();
                namespaceAction.put(namespace, actionName);
                newConfig.put(view, namespaceAction);
            }
        }
        this.config = newConfig;
    }

    private String getActionResultConfig(String result, ActionConfig actionConfig) {
        Map results = actionConfig.getResults();
        ResultConfig resultConfig = (ResultConfig)results.get(result);
        String className = resultConfig.getClassName();
        if (className == null || !className.equals(ServletDispatcherResult.class.getName())) {
            return null;
        }
        Map map = resultConfig.getParams();
        if (map == null) {
            return null;
        }
        String view = (String)map.get("location");
        return view;
    }
}

