/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.xslt;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import webwork.util.ServletValueStack;
import webwork.view.xslt.SAXAdapter.XMLReaderAdapter;
import webwork.view.xslt.SAXAdapter.XMLWalker;

public class XSLTServlet
extends HttpServlet {
    public static final String STACK_NAME = "webwork.result";
    public static final String ROOT_ELEMENT_NAME = "result";
    protected static Log log = LogFactory.getLog((Class)(class$webwork$view$xslt$XSLTServlet == null ? (class$webwork$view$xslt$XSLTServlet = XSLTServlet.class$("webwork.view.xslt.XSLTServlet")) : class$webwork$view$xslt$XSLTServlet));
    private TransformerFactory tfactory;
    private Map templatesCache;
    private XMLWalker xmlWalker;
    static /* synthetic */ Class class$webwork$view$xslt$XSLTServlet;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.templatesCache = new HashMap();
        this.xmlWalker = new XMLWalker();
        this.tfactory = TransformerFactory.newInstance();
        this.tfactory.setErrorListener(new ErrorListener(){

            public void warning(TransformerException exception) throws TransformerException {
                log.info((Object)("Warning: " + exception), (Throwable)exception);
            }

            public void error(TransformerException exception) throws TransformerException {
                log.error((Object)exception);
            }

            public void fatalError(TransformerException exception) throws TransformerException {
                log.fatal((Object)exception);
                throw exception;
            }
        });
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, MalformedURLException {
        try {
            Object result;
            long startTime = 0L;
            if (log.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
            }
            if ((result = ServletValueStack.getStack((ServletRequest)request).findValue(".")) == null) {
                log.info((Object)"Warning: Request attribute \"webwork.result\" is null!");
                result = "Warning: Request attribute \"webwork.result\" is null!";
            }
            Templates templates = this.getTemplates(request);
            Transformer transformer = templates.newTransformer();
            String mimeType = templates.getOutputProperties().getProperty("media-type");
            if (mimeType == null) {
                mimeType = "text/html";
            }
            response.setContentType(mimeType);
            XMLReaderAdapter xmlResultAdapter = new XMLReaderAdapter(this.xmlWalker, result, ROOT_ELEMENT_NAME);
            SAXSource xmlSource = new SAXSource(xmlResultAdapter, new InputSource());
            PrintWriter out = response.getWriter();
            transformer.transform(xmlSource, new StreamResult(out));
            out.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Time:" + (System.currentTimeMillis() - startTime) + "ms"));
            }
        }
        catch (TransformerConfigurationException e) {
            throw new ServletException("XSLT Transformation creation failed: " + e, (Throwable)e);
        }
        catch (TransformerException e) {
            throw new ServletException("XSLT Transformation failed: " + e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Templates getTemplates(HttpServletRequest request) throws TransformerException, IOException {
        URL templateURL;
        String uri = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (uri == null) {
            uri = request.getServletPath();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Template URI: " + uri));
        }
        if ((templateURL = this.getServletContext().getResource(uri)) == null) {
            throw new TransformerException("Stylesheet " + uri + " not found.");
        }
        Templates templates = (Templates)this.templatesCache.get(templateURL);
        if (templates == null) {
            Map map = this.templatesCache;
            synchronized (map) {
                log.debug((Object)("Preparing new XSLT stylesheet: " + templateURL));
                templates = this.tfactory.newTemplates(new StreamSource(templateURL.openStream(), templateURL.toExternalForm()));
                this.templatesCache.put(templateURL, templates);
            }
        }
        return templates;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

