/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.taglib.vui;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import webwork.config.Configuration;
import webwork.util.ContainUtil;
import webwork.view.taglib.IncludeTag;
import webwork.view.taglib.ParamTag;
import webwork.view.taglib.WebWorkBodyTagSupport;
import webwork.view.taglib.vui.BrowserSupport;

public abstract class AbstractVUITag
extends WebWorkBodyTagSupport
implements ParamTag.Parametric {
    protected String themeAttr;
    protected String theme;
    protected String templateHeaderAttr;
    protected String templateFooterAttr;
    protected Map params = new HashMap();

    public abstract String getHeaderTemplate();

    public abstract String getFooterTemplate();

    public String getTheme() {
        if (this.theme == null || this.theme == "") {
            this.theme = (String)this.pageContext.findAttribute("theme");
        }
        if (this.theme == null || this.theme == "") {
            this.theme = Configuration.getString("webwork.ui.theme");
        }
        return this.theme;
    }

    public void setTheme(String aName) {
        this.themeAttr = aName;
    }

    public void setTemplateHeader(String aName) {
        this.templateHeaderAttr = aName;
    }

    public void setTemplateFooter(String aName) {
        this.templateFooterAttr = aName;
    }

    public void addParameter(String name, Object value) {
        this.addParameterInternal(name, value);
    }

    private void addParameterInternal(String name, Object value) {
        this.params.put(name, value);
    }

    public Map getParameters() {
        return this.params;
    }

    public boolean memberOf(Object obj1, Object obj2) {
        return ContainUtil.contains(obj1, obj2);
    }

    protected void getSetParameter(String a, String n) {
        Object value;
        if (a != null && (value = this.findValue(a)) != null) {
            this.addParameterInternal(n, value);
        }
    }

    protected abstract void initializeAttributes();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doStartTag() {
        if (this.themeAttr != null) {
            this.theme = (String)this.findValue(this.themeAttr);
        }
        this.initializeAttributes();
        this.getStack().pushValue(this);
        try {
            String template = this.templateHeaderAttr;
            if (template == null) {
                template = this.getHeaderTemplate();
            }
            IncludeTag.include(this.getTemplateDirectory() + template, this.pageContext);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            int n = 0;
            return n;
        }
        finally {
            this.getStack().popValue();
        }
        return 1;
    }

    public int doAfterBody() throws JspException {
        if (this.bodyContent != null) {
            try {
                JspWriter out = this.getPreviousOut();
                out.print(this.bodyContent.getString());
                this.bodyContent.clearBody();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new JspTagException("Exception:: " + this.toString(ex));
            }
            return 2;
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        if (this.themeAttr != null) {
            this.theme = (String)this.findValue(this.themeAttr);
        }
        this.getStack().pushValue(this);
        try {
            String template = this.templateFooterAttr;
            if (template == null) {
                template = this.getFooterTemplate();
            }
            IncludeTag.include(this.getTemplateDirectory() + template, this.pageContext);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new JspTagException("Exception including footer: " + this.toString(ex));
        }
        finally {
            this.getStack().popValue();
            this.params = new HashMap();
        }
        return 6;
    }

    public String getBrowserUserAgent() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String ua = request.getHeader("User-Agent");
        if (ua == null) {
            ua = request.getHeader("user-agent");
        }
        return ua == null ? "" : ua;
    }

    protected String getTemplateDirectory() {
        String ua = this.getBrowserUserAgent();
        return BrowserSupport.getBrowserTemplateDirectory(ua);
    }

    protected String constructURL(String value) {
        String result;
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        StringBuffer link = new StringBuffer();
        if (value != null) {
            if (value.startsWith("/")) {
                link.append(request.getContextPath());
            }
            link.append(value);
        } else {
            String requestURI = (String)request.getAttribute("webwork.request_uri");
            if (requestURI == null) {
                requestURI = request.getRequestURI();
            }
            link.append(requestURI);
        }
        try {
            result = response.encodeURL(link.toString());
        }
        catch (Exception e) {
            result = link.toString();
        }
        return result;
    }
}

