/*
 * Decompiled with CFR 0.152.
 */
package webwork.multipart;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.LogFactory;
import webwork.config.Configuration;
import webwork.multipart.MultiPartRequest;
import webwork.multipart.ProgressMonitor;
import webwork.multipart.parser.MultipartListener;
import webwork.multipart.parser.MultipartRequest;

public class WebworkMultiPartRequest
extends MultiPartRequest {
    private final ProgressMonitor monitor;
    private MultipartRequest multi;
    static /* synthetic */ Class class$webwork$multipart$WebworkMultiPartRequest;

    private String getEncoding() {
        try {
            String encoding = Configuration.getString("webwork.i18n.encoding");
            if (encoding != null) {
                return encoding;
            }
        }
        catch (IllegalArgumentException e) {
            LogFactory.getLog((Class)(class$webwork$multipart$WebworkMultiPartRequest == null ? (class$webwork$multipart$WebworkMultiPartRequest = WebworkMultiPartRequest.class$("webwork.multipart.WebworkMultiPartRequest")) : class$webwork$multipart$WebworkMultiPartRequest)).info((Object)"Could not get encoding property 'webwork.i18n.encoding' for file upload.  Using system default");
        }
        return null;
    }

    public WebworkMultiPartRequest(HttpServletRequest req, String saveDir, int maxSize) throws IOException {
        boolean memoryUpload = false;
        try {
            memoryUpload = "true".equalsIgnoreCase(Configuration.getString("webwork.multipart.uploadToMemory"));
        }
        catch (IllegalArgumentException e) {
            LogFactory.getLog((Class)(class$webwork$multipart$WebworkMultiPartRequest == null ? (class$webwork$multipart$WebworkMultiPartRequest = WebworkMultiPartRequest.class$("webwork.multipart.WebworkMultiPartRequest")) : class$webwork$multipart$WebworkMultiPartRequest)).info((Object)"Could not read webwork.multipart.uploadToMemory property for file upload. Defaulting to false");
        }
        this.monitor = new ProgressMonitor();
        MultipartListener listener = new MultipartListener(){

            public void fileCompleted(String fileName) {
                WebworkMultiPartRequest.this.monitor.setCompleted(true);
            }

            public void fileStarted(String fileName, long size) {
                WebworkMultiPartRequest.this.monitor.setFileName(fileName);
                WebworkMultiPartRequest.this.monitor.setSize(size);
            }

            public void dataRead(String fileName, int amount) {
                WebworkMultiPartRequest.this.monitor.setRead(WebworkMultiPartRequest.this.monitor.getRead() + amount);
            }
        };
        req.getSession().setAttribute("progress", (Object)this.monitor);
        this.multi = memoryUpload ? new MultipartRequest(req.getContentType(), req.getContentLength(), (InputStream)req.getInputStream(), maxSize, 101, this.getEncoding(), listener) : new MultipartRequest(req.getContentType(), req.getContentLength(), (InputStream)req.getInputStream(), saveDir, maxSize, 101, this.getEncoding(), listener);
        req.getSession().removeAttribute("progress");
    }

    public Enumeration getParameterNames() {
        return this.multi.getParameterNames();
    }

    public String getParameter(String name) {
        return this.multi.getURLParameter(name);
    }

    public String[] getParameterValues(String name) {
        Enumeration e = this.multi.getURLParameters(name);
        if (!e.hasMoreElements()) {
            return null;
        }
        ArrayList values = new ArrayList();
        while (e.hasMoreElements()) {
            values.add(e.nextElement());
        }
        return values.toArray(new String[values.size()]);
    }

    public Enumeration getFileNames() {
        return this.multi.getFileParameterNames();
    }

    public String getFilesystemName(String name) {
        return this.multi.getBaseFilename(name);
    }

    public String getContentType(String name) {
        return this.multi.getContentType(name);
    }

    public File getFile(String name) {
        return this.multi.getFile(name);
    }

    public InputStream getMemoryFileContents(String name) {
        return this.multi.getFileContents(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

