/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.xslt.SAXAdapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import webwork.view.xslt.SAXAdapter.ArrayWalker;
import webwork.view.xslt.SAXAdapter.BeanWalker;
import webwork.view.xslt.SAXAdapter.BooleanWalker;
import webwork.view.xslt.SAXAdapter.CharacterWalker;
import webwork.view.xslt.SAXAdapter.CollectionWalker;
import webwork.view.xslt.SAXAdapter.EnumerationWalker;
import webwork.view.xslt.SAXAdapter.MapWalker;
import webwork.view.xslt.SAXAdapter.NullWalker;
import webwork.view.xslt.SAXAdapter.ToStringWalker;
import webwork.view.xslt.SAXAdapter.Walker;
import webwork.view.xslt.SAXAdapter.dom.NodeWalker;
import webwork.view.xslt.SAXAdapter.dom.TextWalker;

public class XMLWalker {
    private Walker arrayWalker = new ArrayWalker();
    private Walker beanWalker = new BeanWalker();
    private Walker toStringWalker = new ToStringWalker();
    private Walker nullWalker = new NullWalker();
    private List walkers = new ArrayList();
    private Map walkerCache = new HashMap();

    public XMLWalker() {
        this.registerWalker(new CollectionWalker());
        this.registerWalker(new EnumerationWalker());
        this.registerWalker(new MapWalker());
        this.registerWalker(new BooleanWalker());
        this.registerWalker(new CharacterWalker());
        this.registerWalker(new TextWalker());
        this.registerWalker(new NodeWalker());
        this.registerWalker(this.arrayWalker);
        this.registerWalker(this.beanWalker);
        this.registerWalker(this.toStringWalker);
    }

    public void walk(ContentHandler contentHandler, Object object, String name, List walkedInstances) throws SAXException {
        if (object == null) {
            this.nullWalker.walk(this, contentHandler, object, name, walkedInstances);
            return;
        }
        Class<?> klass = object.getClass();
        Walker walker = this.findWalker(klass);
        if (walker != null) {
            walker.walk(this, contentHandler, object, name, walkedInstances);
        } else if (klass.isArray()) {
            this.arrayWalker.walk(this, contentHandler, object, name, walkedInstances);
        } else if (String.class.isAssignableFrom(klass) || klass.isPrimitive() || Number.class.isAssignableFrom(klass)) {
            this.toStringWalker.walk(this, contentHandler, object, name, walkedInstances);
        } else {
            this.beanWalker.walk(this, contentHandler, object, name, walkedInstances);
        }
    }

    public void registerWalker(Walker walker) {
        this.walkerCache.clear();
        this.walkers.add(walker);
    }

    private synchronized Walker findWalker(Class klass) {
        if (this.walkerCache.containsKey(klass)) {
            return (Walker)this.walkerCache.get(klass);
        }
        Walker walker = null;
        for (Walker tryWalker : this.walkers) {
            if (!tryWalker.getWalkedType().isAssignableFrom(klass)) continue;
            walker = tryWalker;
            break;
        }
        LogFactory.getLog(this.getClass()).debug((Object)("Caching " + (walker != null ? "walker " + walker.getClass().getName() : "no walker") + " for " + klass.getName()));
        this.walkerCache.put(klass, walker);
        return walker;
    }

    public Walker getToStringWalker() {
        return this.toStringWalker;
    }
}

