/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.taglib.ui.table;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import webwork.view.taglib.ui.table.AbstractFilterModel;
import webwork.view.taglib.ui.table.SortableTableModel;

public class SortFilterModel
extends AbstractFilterModel
implements TableModelListener,
SortableTableModel {
    private int sortColumn = -1;
    private ArrayList rows = new ArrayList();
    private boolean dirty = true;
    private String _sortDirection = "NONE";

    public SortFilterModel(TableModel tm) {
        super(tm);
        this.setModel(tm);
    }

    protected void refresh() {
        this.rows.clear();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            this.rows.add(new Row(i));
        }
        if (this.dirty && this.sortColumn > -1) {
            this.sort(this.sortColumn);
        }
    }

    protected void sort(int c) {
        boolean sorted = this.sortColumn == c;
        this.sortColumn = c;
        if (this.dirty || !sorted) {
            Collections.sort(this.rows);
            this.dirty = false;
        } else {
            Collections.reverse(this.rows);
        }
        this.fireTableDataChanged();
    }

    public void addMouseListener(final JTable table) {
        table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() < 2) {
                    return;
                }
                int tableColumn = table.columnAtPoint(event.getPoint());
                int modelColumn = table.convertColumnIndexToModel(tableColumn);
                SortFilterModel.this.sort(modelColumn);
            }
        });
    }

    @Override
    public Object getValueAt(int r, int c) {
        if (this.rows.size() > 0 && r < this.rows.size()) {
            return this.model.getValueAt(((Row)this.rows.get((int)r)).index, c);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        if (this.rows.size() > 0 && r < this.rows.size()) {
            return this.model.isCellEditable(((Row)this.rows.get((int)r)).index, c);
        }
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int r, int c) {
        if (this.rows.size() > 0 && r < this.rows.size()) {
            this.model.setValueAt(aValue, ((Row)this.rows.get((int)r)).index, c);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.dirty = true;
        this.refresh();
        this.fireTableChanged(e);
    }

    @Override
    public void removeRow(int rowNum) throws ArrayIndexOutOfBoundsException, IllegalStateException {
        int mappedRow = ((Row)this.rows.get((int)rowNum)).index;
        super.removeRow(mappedRow);
    }

    @Override
    public void setModel(TableModel tm) {
        super.setModel(tm);
        this.rows.ensureCapacity(this.model.getRowCount());
        this.model.addTableModelListener(this);
        this.sortColumn = -1;
        this.dirty = true;
        this.refresh();
    }

    @Override
    public int getSortedColumnNumber() {
        return this.sortColumn;
    }

    @Override
    public void sort(int columnNumber, String direction) {
        this._sortDirection = "ASC";
        this.dirty = true;
        this.sort(columnNumber);
        if ("DESC".equals(direction)) {
            this.sort(columnNumber);
            this._sortDirection = "DESC";
        }
    }

    @Override
    public String getSortedDirection(int columnNumber) {
        if (this.getSortedColumnNumber() < 0) {
            return "NONE";
        }
        return this._sortDirection;
    }

    private class Row
    implements Comparable {
        public int index;

        public Row(int index) {
            this.index = index;
        }

        public int compareTo(Object other) {
            boolean areTheyCompareable;
            Row otherRow = (Row)other;
            Object a = SortFilterModel.this.model.getValueAt(this.index, SortFilterModel.this.sortColumn);
            Object b = SortFilterModel.this.model.getValueAt(otherRow.index, SortFilterModel.this.sortColumn);
            boolean bl = areTheyCompareable = a instanceof Comparable && b instanceof Comparable && a.getClass() == b.getClass();
            if (areTheyCompareable) {
                return ((Comparable)a).compareTo((Comparable)b);
            }
            return a.toString().compareTo(b.toString());
        }
    }
}

