/*
 * Decompiled with CFR 0.152.
 */
package webwork.dispatcher;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webwork.dispatcher.GenericDispatcher;
import webwork.dispatcher.ServletDispatcher;

public class CleanupFilter
implements Filter {
    public static final String DO_NOT_CLEAN = "webwork.cleanupfilter";
    private static final String FILTER_ALREADY_RUN_KEY = CleanupFilter.class.getName() + "_run";
    private static Log LOG = LogFactory.getLog(ServletDispatcher.class);

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest.getAttribute(FILTER_ALREADY_RUN_KEY) != null) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            servletRequest.setAttribute(FILTER_ALREADY_RUN_KEY, (Object)new Boolean(true));
            servletRequest.setAttribute(DO_NOT_CLEAN, (Object)Boolean.TRUE);
            filterChain.doFilter(servletRequest, servletResponse);
            GenericDispatcher gd = (GenericDispatcher)servletRequest.getAttribute("webwork.generic.dispatcher");
            if (gd != null) {
                LOG.debug((Object)"Cleaning up generic dispatcher.");
                gd.finalizeContext();
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

