/*
 * Decompiled with CFR 0.152.
 */
package webwork.action.factory;

import webwork.action.Action;
import webwork.action.factory.ActionFactory;
import webwork.action.factory.ChainingActionFactoryProxy;
import webwork.action.factory.JavaActionFactory;
import webwork.action.factory.ReloadHelperActionFactoryProxy;
import webwork.action.factory.ReloadingJavaActionFactory;
import webwork.config.Configuration;

public class DefaultActionFactory
extends ActionFactory {
    protected ActionFactory factory = new ChainingActionFactoryProxy(this.factory);

    public DefaultActionFactory() {
        try {
            boolean reloadEnabled = "true".equalsIgnoreCase(Configuration.getString("webwork.configuration.xml.reload"));
            if (reloadEnabled) {
                this.factory = new ReloadHelperActionFactoryProxy(this.factory);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected ActionFactory getRootFactory() {
        JavaActionFactory root = null;
        try {
            boolean reloadEnabled = "true".equalsIgnoreCase(Configuration.getString("webwork.action.java.reload"));
            if (reloadEnabled) {
                root = new ReloadingJavaActionFactory();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (root == null) {
            root = new JavaActionFactory();
        }
        return root;
    }

    @Override
    public Action getActionImpl(String name) throws Exception {
        return this.factory.getActionImpl(name);
    }
}

