/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.xslt.SAXAdapter;

import org.apache.commons.logging.*;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import webwork.util.InjectionUtils;

public class BeanWalker extends AbstractWalker
{

    private static final Object[] NULLPARAMS = new Object[0];

    /**
     * Cache can savely be static because the cached information is the same for all instances of this class.
     */
    private static Map propertyDescriptorCache;

    public void doWalk(XMLWalker rootWalker, ContentHandler contentHandler, Object value, String attributeName, List walkedInstances)
            throws SAXException
    {
        if (value == null)
        {
            LogFactory.getLog(this.getClass()).error(attributeName + " == null, returning!");
            return;
        } // Guardclause

        walkedInstances.add(value);

        try
        {
            Class type = value.getClass();
            PropertyDescriptor[] props = getPropertyDescriptors(value);
            if (props.length > 0)
            {
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "class", "", "CDATA", type.getName());
                contentHandler.startElement("", attributeName, "", attributes);
                for (int i = 0; i < props.length; i++)
                {
                    Method m = props[i].getReadMethod();
                    if (m == null)
                    {
                        //FIXME: write only property or indexed access
                        continue;
                    }
                    String propertyName = props[i].getName();
                    Object propertyValue;
                    /** 999 white magic hack start 999 **
                     * some property accessors will throw exceptions,
                     * e.g. getLocale() in webwork.ActionSupport *grrr*
                     * IMHO property accessor should not have those side
                     * effects - meier@o-matic.de
                     */
                    try
                    {
                        propertyValue = InjectionUtils.invoke(m, value, NULLPARAMS);
                    }
                    catch (Exception e)
                    {
                        continue;
                    }
                    /** 999 white magic hack end 999 **/

                    rootWalker.walk(contentHandler, propertyValue, propertyName, walkedInstances);

                }
                contentHandler.endElement("", attributeName, "");
            }
            else
            {
                // No properties found
                LogFactory.getLog(this.getClass()).debug("Class " + type.getName() + " has no readable properties, " + " trying to walk with toStringWalker...");
                rootWalker.getToStringWalker().walk(rootWalker, contentHandler, value, attributeName, walkedInstances);
            }
        }
        catch (IntrospectionException e)
        {
            throw new SAXException(e);
        }
    }

    /**
     * @return A private Class not visible from outside. This walker is not really used by the registry in
     *         XMLReaderAdapter. If it would match java.lang.Object the fall back for primitives and java.lang.Number
     *         would not work any more.
     */
    public final Class getWalkedType()
    {
        return NoClass.class;
    }

    /**
     * This private class is returned by @see getWalkedType pro forma.
     */
    private class NoClass
    {
    }

    /**
     * Caching facade method to Introspector.getBeanInfo(Class, Class).getPropertyDescriptors();
     */
    private synchronized PropertyDescriptor[] getPropertyDescriptors(Object bean) throws IntrospectionException
    {
        if (propertyDescriptorCache == null)
        {
            propertyDescriptorCache = new HashMap();
        }

        PropertyDescriptor[] props = (PropertyDescriptor[]) propertyDescriptorCache.get(bean.getClass());
        if (props == null)
        {
            LogFactory.getLog(this.getClass()).debug("Caching property descriptor for " + bean.getClass().getName());
            props = Introspector.getBeanInfo(bean.getClass(), Object.class).getPropertyDescriptors();
            propertyDescriptorCache.put(bean.getClass(), props);
        }
        return props;
    }
}
