/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib.iterator;

import webwork.view.taglib.ActionTag;
import webwork.util.IteratorGenerator;
import webwork.util.ValueStack;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

/**
 * Generate an iterator
 *
 * @author Rickard \u00D6berg (rickard@dreambean.com)
 * @version $Revision: 1.4 $
 */
public class IteratorGeneratorTag
        extends ActionTag
{
    // Attributes ----------------------------------------------------
    String valueAttr;
    String countAttr;
    String separatorAttr;

    // Constructor ---------------------------------------------------
    public void setParent(Tag t)
    {
        super.setParent(t);
        setName("'" + IteratorGenerator.class.getName() + "'");
    }

    // Public --------------------------------------------------------
    public void setVal(String aValue)
    {
        valueAttr = aValue;
    }

    public void setCount(String aCount)
    {
        countAttr = aCount;
    }

    public void setSeparator(String aChar)
    {
        separatorAttr = aChar;
    }

    // BodyTag implementation ----------------------------------------
    public int doStartTag() throws JspException
    {
        super.doStartTag();

        // Pop holder temporarily while we resolve names
        Object holder = getStack().popValue();

        ((IteratorGenerator) bean).setValues(findValue(valueAttr));
        if (countAttr != null)
        {
            ((IteratorGenerator) bean).setCount(Integer.parseInt(findString(countAttr)));
        }
        if (separatorAttr != null)
        {
            ((IteratorGenerator) bean).setSeparator(findString(separatorAttr));
        }

        // Execute the action now that it has got the appropriate values set
        // Trigger the execute by getting the value from the holder object
        if (holder instanceof ValueStack.ValueHolder)
        {
            ((ValueStack.ValueHolder) holder).getValue();
        }

        // Push holder back on stack
        getStack().pushValue(holder);
        return EVAL_BODY_INCLUDE;
    }
}
