/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.util.editor;

import webwork.action.ValidationEditorSupport;

import java.math.BigDecimal;

/**
 * @author Marco Papini <mpapini@cinetica.it>
 * @version $Revision: 1.4 $
 * @see java.beans.PropertyEditorSupport
 * @see ValidationEditorSupport
 * @see FastPropertyEditor
 * @see PropertyEditorException
 */
public class BigDecimalEditor extends ValidationEditorSupport implements FastPropertyEditor
{

    public void setAsText(String txt)
    {
        setValue(getAsValue(txt));
    }

    public Object getAsValue(String txt)
    {
        if (txt == null || txt.length() == 0)
        {
            return null;
        }
        try
        {
            return new BigDecimal(txt);
        }
        catch (NumberFormatException e)
        {
            throw new PropertyEditorException(PropertyMessage.BAD_BIGDECIMAL, txt);
        }
    }
}

