/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.util;

import java.util.Enumeration;
import java.util.Iterator;

/**
 * A base class for iterator filters
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.10 $
 */
public abstract class IteratorFilterSupport
{
    // Protected implementation --------------------------------------
    protected Object getIterator(Object source)
    {
        return MakeIterator.convert(source);
    }

    // Wrapper for enumerations
    public class EnumerationIterator
            implements Iterator
    {
        Enumeration e;

        public EnumerationIterator(Enumeration aEnum)
        {
            e = aEnum;
        }

        public boolean hasNext()
        {
            return e.hasMoreElements();
        }

        public Object next()
        {
            return e.nextElement();
        }

        public void remove()
        {
            throw new UnsupportedOperationException("Remove is not supported in IteratorFilterSupport.");
        }
    }
}
