/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.action.factory;

import javax.servlet.ServletContext;
import java.util.*;

/**
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.9 $
 */
public class ApplicationMap extends AbstractMap
{
    ServletContext context;
    Set entries;

    public ApplicationMap(ServletContext ctx)
    {
        this.context = ctx;
    }

    public Set entrySet()
    {
        if (entries == null)
        {
            entries = new HashSet();

            // Add servlet context attributes
            Enumeration e = context.getAttributeNames();
            while (e.hasMoreElements())
            {
                final String key = e.nextElement().toString();
                final Object value = context.getAttribute(key);
                entries.add(new Map.Entry()
                {
                    public boolean equals(Object obj)
                    {
                        Map.Entry entry = (Map.Entry) obj;
                        return (key == null ?
                                entry.getKey() == null : key.equals(entry.getKey())) &&
                                (value == null ?
                                        entry.getValue() == null : value.equals(entry.getValue()));
                    }

                    public int hashCode()
                    {
                        return (key == null ? 0 : key.hashCode()) ^
                                (value == null ? 0 : value.hashCode());
                    }

                    public Object getKey()
                    {
                        return key;
                    }

                    public Object getValue()
                    {
                        return value;
                    }

                    public Object setValue(Object obj)
                    {
                        context.setAttribute(key, obj);
                        return value;
                    }
                });
            }

            // Add servlet context init parameters
            e = context.getInitParameterNames();
            while (e.hasMoreElements())
            {
                final String key = e.nextElement().toString();
                final Object value = context.getInitParameter(key);
                entries.add(new Map.Entry()
                {
                    public boolean equals(Object obj)
                    {
                        Map.Entry entry = (Map.Entry) obj;
                        return (key == null ?
                                entry.getKey() == null : key.equals(entry.getKey())) &&
                                (value == null ?
                                        entry.getValue() == null : value.equals(entry.getValue()));
                    }

                    public int hashCode()
                    {
                        return (key == null ? 0 : key.hashCode()) ^
                                (value == null ? 0 : value.hashCode());
                    }

                    public Object getKey()
                    {
                        return key;
                    }

                    public Object getValue()
                    {
                        return value;
                    }

                    public Object setValue(Object obj)
                    {
                        context.setAttribute(key, obj);
                        return value;
                    }
                });
            }
        }

        return entries;
    }

    public Object put(Object key, Object value)
    {
        entries = null;
        context.setAttribute(key.toString(), value);
        return get(key);
    }

    public Object get(Object key)
    {
        // Try context attributes first, then init parameters
        // This gives the proper shadowing effects
        String keyString = key.toString();
        Object value = context.getAttribute(keyString);
        return value == null ? context.getInitParameter(keyString) : value;
    }

    public Object remove(Object key)
    {
        entries = null;
        Object value = get(key);
        context.removeAttribute(key.toString());
        return value;
    }

    public void clear()
    {
        entries = null;
        Enumeration e = context.getAttributeNames();
        while (e.hasMoreElements())
        {
            context.removeAttribute(e.nextElement().toString());
        }
    }
}
