/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.action;

/**
 * An Action wanting to prepare its state before receiving parameters should implement this interface.
 * <p/>
 * A common use is to get current state from a database, which then is overwritten partially by input parameters. The
 * new state, including the old that was not overwritten, may then be sent back to the database
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.6 $
 * @see Action
 */
public interface PrepareAction
{
    // Public --------------------------------------------------------
    /**
     * This method is called to allow the action to prepare itself before receiving parameters through its set-methods.
     * <p/>
     * All *Aware interfaces are checked before this, so the action can rely on addition information to have been sent
     * through the callbacks (e.g. the application session, or user session)
     *
     * @throws Exception thrown if a system level exception occurs.
     */
    public void prepare() throws Exception;
}
