/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.action;

import java.util.Map;

/**
 * Actions that want to be aware of the application Map object should implement this interface. This will give them
 * access to a Map where they can put objects that should be available to other parts of the application.
 * <p/>
 * Typical uses are configuration objects and caches.
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.6 $
 * @deprecated Use {@link ActionContext#getApplication()} instead.
 */
public interface ApplicationAware
{
    // Public --------------------------------------------------------
    public void setApplication(Map application);
}
