/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.xslt.SAXAdapter;

import org.apache.commons.logging.*;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

import java.util.List;

public abstract class AbstractWalker implements Walker
{
    public void walk(XMLWalker rootWalker, ContentHandler contentHandler, Object value,
            String attributeName, List walkedInstances) throws SAXException
    {
        if (walkedInstances.contains(value))
        {
            LogFactory.getLog(this.getClass()).debug(attributeName + " alreay walked, cutting circular reference.");
            return;
        }
        doWalk(rootWalker, contentHandler, value, attributeName, walkedInstances);
    }

    public abstract void doWalk(XMLWalker rootWalker, ContentHandler contentHandler, Object value,
            String attributeName, List walkedInstances) throws SAXException;

}
