/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib.ui;

import javax.servlet.jsp.JspException;

/**
 * Select list tag.
 *
 * @author Rickard \u00D6berg (rickard@dreambean.com)
 * @version $Revision: 1.7 $
 */
public class SelectTag extends AbstractHTMLListTag
{
    // Attributes ----------------------------------------------------
    protected String sizeAttr;
    protected String multipleAttr;
    protected String headerKeyAttr;
    protected String headerValueAttr;

    // Public --------------------------------------------------------
    public String getTemplate()
    {
        return useMap ? "selectmap" : "select";
    }

    public void setSize(String aSize)
    {
        this.sizeAttr = aSize;
    }

    public void setMultiple(String multiple)
    {
        this.multipleAttr = multiple;
    }

    public void setHeaderKey(String headerKey)
    {
        this.headerKeyAttr = headerKey;
    }

    public void setHeaderValue(String headerValue)
    {
        this.headerValueAttr = headerValue;
    }

    // BodyTag implementation ----------------------------------------
    public int doEndTag()
            throws JspException
    {
        if (sizeAttr != null)
        {
            this.addParameter("size", findValue(sizeAttr));
        }
        if (multipleAttr != null)
        {
            this.addParameter("multiple", findValue(multipleAttr));
        }
        if (headerKeyAttr != null && headerValueAttr != null)
        {
            this.addParameter("headerKey", findValue(headerKeyAttr));
            this.addParameter("headerValue", findValue(headerValueAttr));
        }

        return super.doEndTag();
    }
}
