/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.view.taglib;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import webwork.action.ActionContext;
import webwork.action.ServletActionContext;
import webwork.dispatcher.GenericDispatcher;

import java.security.Principal;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

/**
 * Instantiate an Action and execute it. It is lazily executed, which means that you can set parameters by using the
 * "param" tag.
 *
 * @author Rickard \u00D6berg (rickard@dreambean.com)
 * @version $Revision: 1.22 $
 */
public class ActionTag extends BeanTag
{
    protected static Log log = LogFactory.getLog(ActionTag.class);

    GenericDispatcher gd;

    // BodyTag implementation ----------------------------------------
    @Override
    public int doStartTag() throws JspException
    {
        final String name = (String) findValue(nameAttr);
        if (name == null)
        {
            throw new JspException("No action named " + nameAttr + " found. Try putting quotes around name");
        }

        final Principal oldPrincipal = ActionContext.getPrincipal();

        gd = new GenericDispatcher(name, true);
        gd.prepareContext();
        ServletActionContext.setContext((HttpServletRequest) pageContext.getRequest(), (HttpServletResponse) pageContext.getResponse(),
                pageContext.getServletContext(), name);
        gd.prepareValueStack();
        ActionContext.setPrincipal(oldPrincipal);
        try
        {
            gd.executeAction();
            bean = gd.getActions().get(0);
        }
        catch (final RuntimeException e)
        {
            throw e;
        }
        catch (final Exception t)
        {
            throw new JspException("Caught throwable when instantiating action: " + name, t);
        }
        if (getId() != null)
        {
            // The bean variable is needed above so that parameters etc
            // can be set on the action.
            // Now we need to get the ValueHolder object from the stack
            // and store it in the pageContext so that the action can be
            // executed before it is accessed.
            final Object lazyValueHolder = getStack().peek();
            pageContext.setAttribute(getId(), lazyValueHolder);
            pageContext.setAttribute(getId(), lazyValueHolder, PageContext.REQUEST_SCOPE);
        }

        return EVAL_BODY_INCLUDE;
    }

    @Override
    public int doEndTag() throws JspException
    {
        gd.finish();
        gd.finalizeContext();
        gd = null;
        bean = null; // clear bean at the end of the request - WW-797
        return EVAL_PAGE;
    }
}
