/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/**
 * A bean that generates an iterator filled with a given object
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.8 $
 */
public class IteratorGenerator
        implements java.util.Iterator, webwork.action.Action
{
    // Attributes ----------------------------------------------------
    int count = 0;
    int currentCount = 0;
    String separator;
    Object value;
    List values;

    // Public --------------------------------------------------------
    public void setValues(Object aValue)
    {
        value = aValue;
    }

    public void setCount(int aCount)
    {
        this.count = aCount;
    }

    public void setSeparator(String aChar)
    {
        separator = aChar;
    }

    public boolean getHasNext()
    {
        return hasNext();
    }

    public Object getNext()
    {
        return next();
    }

    // Action implementation -----------------------------------------
    public String execute()
    {
        if (value == null)
        {
            return ERROR;
        }
        else
        {
            values = new ArrayList();
            if (separator != null)
            {
                StringTokenizer tokens = new StringTokenizer(value.toString(), separator);
                while (tokens.hasMoreTokens())
                {
                    values.add(tokens.nextToken());
                }
            }
            else
            {
                values.add(value.toString());
            }

            // Count default is the size of the list of values
            if (count == 0)
            {
                count = values.size();
            }

            return SUCCESS;
        }
    }

    // Iterator implementation ---------------------------------------
    public boolean hasNext()
    {
        return (value == null) ? false : (currentCount < count || count == -1);
    }

    public Object next()
    {
        try
        {
            return values.get(currentCount % values.size());
        }
        finally
        {
            currentCount++;
        }
    }

    public void remove()
    {
        throw new UnsupportedOperationException("Remove is not supported in IteratorGenerator.");
    }
}
