package webwork.interceptor;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class NestedInterceptorChain implements InterceptorChain
{
    private final InterceptorChain outerChain;
    private final Iterator<Interceptor> iterator;

    public NestedInterceptorChain(InterceptorChain outerChain, List<Interceptor> interceptors)
    {
        this(outerChain, interceptors == null ? Collections.<Interceptor>emptyList().iterator() : interceptors.iterator());
    }

    public NestedInterceptorChain(InterceptorChain outerChain, Iterator<Interceptor> iterator)
    {
        this.outerChain = outerChain;
        this.iterator = iterator == null ? Collections.<Interceptor>emptyList().iterator() : iterator;
    }

    public String proceed() throws Exception
    {
        if (iterator.hasNext())
        {
            return iterator.next().intercept(this);
        }
        else
        {
            return outerChain.proceed();
        }
    }
}