/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.jdom;

import java.net.URL;
import java.net.MalformedURLException;

import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.apache.commons.logging.*;

import webwork.action.ActionSupport;
import webwork.action.ResultException;
import webwork.action.CommandDriven;

import webwork.action.ServletRequestAware;

import javax.servlet.http.HttpServletRequest;


/**
 * A simple Action used to fetch a remote URL, parse it using JDOM, and make the result available to the View.
 *
 * @author Maurice C. Parker (maurice@vineyardenterprise.com)
 * @version $Revision: 1.5 $
 */
public class JDOMUrl
        extends ActionSupport
        implements CommandDriven, ServletRequestAware
{

    // Attributes ----------------------------------------------------
    String url;
    Document document;
    HttpServletRequest request;

    // Public --------------------------------------------------------
    public void setUrl(String url)
    {
        this.url = url;
    }

    public String getUrl()
    {
        return url;
    }

    public Document getDocument()
    {
        return document;
    }

    public void setServletRequest(HttpServletRequest request)
    {
        this.request = request;
    }

    protected void doValidation()
    {
        if (url == null)
        {
            addErrorMessage("No source selected");
        }
    }

    protected String doExecute()
            throws Exception
    {
        URL xmlUrl;

        try
        {
            xmlUrl = new URL(url);
        }
        catch (MalformedURLException e)
        {
            addErrorMessage("Not a valid URL");
            return ERROR;
        }

        try
        {
            SAXBuilder builder = new SAXBuilder();
            document = builder.build(xmlUrl);
        }
        catch (Exception e)
        {
            LogFactory.getLog(getClass()).error("Could not load XML document", e);
            return ERROR;
        }

        return SUCCESS;
    }

    protected String buildUrl(String uri)
    {
        return request.getScheme() + "://" + request.getServerName() + ":" +
                request.getServerPort() + request.getContextPath() + "/" + uri;
    }
}
