/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.bank;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.util.ArrayList;

/**
 * This code is an adaptation of the Struts example from the JavaWorld article by Thor Kristmundsson.
 * http://www.javaworld.com/javaworld/jw-12-2000/jw-1201-struts_p.html
 */
public class TransferBeanInfo
        extends SimpleBeanInfo
{
    // Public  -------------------------------------------------------

    public PropertyDescriptor[] getPropertyDescriptors()
    {
        // Create a list of property descriptors
        // The main reason is to provide input validation through PropertyEditors
        // This will give transparent validation to the Actions
        // The validation requirements can then be changed without having
        // to change the Actions at all, which is a big win, especially if the
        // same Actions are to be reused in a similar project but with different
        // input validation requirements, which is common
        try
        {
            ArrayList list = new ArrayList();

            PropertyDescriptor descriptor;

            descriptor = new PropertyDescriptor("receiver", Transfer.class);
            descriptor.setPropertyEditorClass(NameEditor.class);
            list.add(descriptor);

            descriptor = new PropertyDescriptor("account", Transfer.class);
            descriptor.setPropertyEditorClass(AccountEditor.class);
            list.add(descriptor);

            descriptor = new PropertyDescriptor("amount", Transfer.class);
            descriptor.setPropertyEditorClass(AmountEditor.class);
            list.add(descriptor);

            descriptor = new PropertyDescriptor("date", Transfer.class);
            list.add(descriptor);

            return (PropertyDescriptor[]) list.toArray(new PropertyDescriptor[list.size()]);
        }
        catch (Exception e)
        {
            e.printStackTrace();
            return super.getPropertyDescriptors();
        }
    }

    public BeanInfo[] getAdditionalBeanInfo()
    {
        try
        {
            return new BeanInfo[] { Introspector.getBeanInfo(Transfer.class.getSuperclass()) };
        }
        catch (Exception e)
        {
            e.printStackTrace();
            return super.getAdditionalBeanInfo();
        }
    }

}