/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples.bank;

import webwork.action.ValidationEditorSupport;

/**
 * This code is an adaptation of the Struts example from the JavaWorld article by Thor Kristmundsson.
 * http://www.javaworld.com/javaworld/jw-12-2000/jw-1201-struts_p.html
 */
public class AmountEditor
        extends ValidationEditorSupport
{
    public void setAsText(String txt)
    {
        // Validate amount
        if (txt.length() > 11)
        {
            throw new IllegalArgumentException("Amount can have 8 digits plus 2 decimals");
        }

        if (txt.length() == 0)
        {
            throw new IllegalArgumentException("Amount must be specified");
        }

        // Convert (will check format)
        try
        {
            Float amount = new Float(txt);

            // Check value
            if (amount.floatValue() <= 0)
            {
                throw new IllegalArgumentException("Amount must be above 0");
            }

            setValue(amount);
        }
        catch (NumberFormatException e)
        {
            throw new IllegalArgumentException("Amount can have 8 digits plus 2 decimals");
        }
    }
}