/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples;

import webwork.action.ActionSupport;
import webwork.action.ParameterAware;

import javax.swing.table.*;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class TableAction
        extends ActionSupport
        implements ParameterAware
{
    protected String[] _strings = new String[5];
    protected String _other = "other";
    protected Dummy _dummy = new Dummy();

    protected DefaultTableModel _result = null;

    public TableAction()
    {
        _strings[0] = "first";
        _strings[1] = "second";
        _strings[2] = "third";
        _strings[3] = "fourth";
        _strings[4] = "fifth";

        buildTableModel();
    }

    protected void buildTableModel()
    {
        String[] columnNames = { "First", "second", "third", "fourth", "fifth", "sixth" };
        _result = new DefaultTableModel(columnNames, 0);

        Vector curRow = new Vector();
        curRow.add(Calendar.getInstance().getTime());
        curRow.add("this should not be seen!");
        curRow.add(new Double("69.96"));
        curRow.add("default renderer");
        curRow.add(new Integer(9));
        curRow.add("default renderer");
        _result.addRow(curRow);

        curRow = new Vector();
        curRow.add(java.sql.Date.valueOf("2001-02-02"));
        curRow.add("this should not be seen! 2");
        curRow.add(new Double("96.69"));
        curRow.add("default renderer (2)");
        curRow.add(new Integer(-999999));
        curRow.add(new Integer(2));
        _result.addRow(curRow);

        curRow = new Vector();
        curRow.add(java.sql.Date.valueOf("2001-03-03"));
        curRow.add("this should not be seen! 3");
        curRow.add(new Double("123341.34545"));
        curRow.add("default renderer (3)");
        curRow.add(new Integer(0));
        curRow.add("weird stuff!");
        _result.addRow(curRow);

    }

    public TableModel getResult()
    {
        return _result;
    }

    public Dummy getDummy()
    {
        return _dummy;
    }

    public void setParameters(Map parameters)
    {
//		System.out.println("We are in set parameters of TestAction.....");
        Iterator keys = parameters.keySet().iterator();
//		while(keys.hasNext())
//		{
//			System.out.println("     "+keys.next().toString());
//		}
//		System.out.println("Those were the parameters of TestAction!");
    }

    public String getRunThree(String one, String two, String three)
    {
//		System.out.println("one   = "+one);
//		System.out.println("two   = "+two);
//		System.out.println("three = "+three);
        return one + " " + two + " " + three;
    }

    public String getRunTwo(String one, String two)
    {
//		System.out.println("one   = "+one);
//		System.out.println("two   = "+two);
        return one + " " + two;
    }

    public String getRunOne(String one)
    {
//		System.out.println("one   = "+one);
        return one;
    }

    public String getField(int index)
    {
        return _strings[index];
    }

    public void setField(int index, String string)
    {
        _strings[index] = string;
    }

    public String getOther()
    {
        return _other;
    }

    public void setOther(String other)
    {
        _other = other;
    }

    public class Dummy
    {
        protected String _name = "the dummy name field";

        public String getName()
        {
            return _name;
        }

        public void setName(String name)
        {
            _name = name;
        }
    }
}
