/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples;

import webwork.action.ActionSupport;
import webwork.action.CommandDriven;

/**
 * A simple form that tests the expression language's ability to get and set properties.
 *
 * @author Maurice C. Parker (Maurice@VineyardEnterprise.com)
 * @version $Revision: 1.4 $
 */
public class ExprFormTest
        extends ActionSupport
        implements CommandDriven
{
    Person person = new Person();

    // Public --------------------------------------------------------
    public Person getPerson()
    {
        return person;
    }

    public void setPerson(Person person)
    {
        this.person = person;
    }

    // Action implementation -----------------------------------------
    protected void doValidation()
    {
        // Validate
        if (person.getName().equals("Rickard"))
        {
            addError("person/name", "Please change the default name.");
        }

        if (person.getEmail().equals("rickard@dreambean.com"))
        {
            addError("person/email", "Please change the default email address.");
        }
    }

    protected String doExecute()
    {
        // Process data
        return SUCCESS;
    }
}
