/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.examples;

import org.jdom.input.SAXBuilder;
import org.jdom.Document;
import webwork.action.ActionSupport;
import webwork.util.ClassLoaderUtils;

import javax.xml.parsers.DocumentBuilderFactory;
import java.net.URL;

/**
 * Read list of actions and view mappings
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.comd)
 * @version $Revision: 1.6 $
 */
public class ActionListing extends ActionSupport
{
    Document document;

    public Document getDocument()
    {
        return document;
    }

    // Action implementation -----------------------------------------
    protected String doExecute() throws Exception
    {
        URL actions = ClassLoaderUtils.getResource("actions.xml", ActionListing.class);
        SAXBuilder builder = new SAXBuilder();
        document = builder.build(actions);
        return SUCCESS;
    }
}
