/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.action;

import javax.servlet.http.HttpServletRequest;

/**
 * All Actions that want to have access to the servlet request objects must implement this interface.
 * <p/>
 * This interface is only relevant if the Action is used in a servlet environment.
 * <p/>
 * Note that using this interface makes the Action tied to a servlet environment, so it should be avoided if possible.
 *
 * @author Rickard \u00D6berg (rickard@middleware-company.com)
 * @version $Revision: 1.7 $
 * @deprecated Use {@link ServletActionContext#getRequest()} instead.
 */
public interface ServletRequestAware
{
    // Public --------------------------------------------------------
    public void setServletRequest(HttpServletRequest request);
}
