/*
 * WebWork, Web Application Framework
 *
 * Distributable under Apache license.
 * See terms of license at opensource.org
 */
package webwork.action;

/**
 * Provides multiple execution paths or "commands" for actions implementing this interface.
 *
 * @see webwork.action.factory.DefaultActionFactory
 * @see webwork.action.factory.CommandActionFactoryProxy
 */
public interface CommandDriven
{
    /**
     * @return the name of the command that is currently in play or null if no command has been set
     */
    public String getCommandName();

    /**
     * Sets the command for an action.
     *
     * This has been DELIBERATELY set to a non JavaBean name because Action chaining copies all getters to setters and hence
     * the if its a getter/setter pair, then the command value will be unintentionally overwritten.
     *
     * @param command the new command in play
     */
    public void setCommand(String command);
}
