/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.xslt.SAXAdapter;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import webwork.util.InjectionUtils;
import webwork.view.xslt.SAXAdapter.AbstractWalker;
import webwork.view.xslt.SAXAdapter.XMLWalker;

public class BeanWalker
extends AbstractWalker {
    private static final Object[] NULLPARAMS = new Object[0];
    private static Map propertyDescriptorCache;

    public void doWalk(XMLWalker rootWalker, ContentHandler contentHandler, Object value, String attributeName, List walkedInstances) throws SAXException {
        block7: {
            if (value == null) {
                LogFactory.getLog(this.getClass()).error((Object)(attributeName + " == null, returning!"));
                return;
            }
            walkedInstances.add(value);
            try {
                Class<?> type = value.getClass();
                PropertyDescriptor[] props = this.getPropertyDescriptors(value);
                if (props.length > 0) {
                    AttributesImpl attributes = new AttributesImpl();
                    attributes.addAttribute("", "class", "", "CDATA", type.getName());
                    contentHandler.startElement("", attributeName, "", attributes);
                    for (int i = 0; i < props.length; ++i) {
                        Object propertyValue;
                        Method m = props[i].getReadMethod();
                        if (m == null) continue;
                        String propertyName = props[i].getName();
                        try {
                            propertyValue = InjectionUtils.invoke(m, value, NULLPARAMS);
                        }
                        catch (Exception e) {
                            continue;
                        }
                        rootWalker.walk(contentHandler, propertyValue, propertyName, walkedInstances);
                    }
                    contentHandler.endElement("", attributeName, "");
                    break block7;
                }
                LogFactory.getLog(this.getClass()).debug((Object)("Class " + type.getName() + " has no readable properties, " + " trying to walk with toStringWalker..."));
                rootWalker.getToStringWalker().walk(rootWalker, contentHandler, value, attributeName, walkedInstances);
            }
            catch (IntrospectionException e) {
                throw new SAXException(e);
            }
        }
    }

    public final Class getWalkedType() {
        return NoClass.class;
    }

    private synchronized PropertyDescriptor[] getPropertyDescriptors(Object bean) throws IntrospectionException {
        PropertyDescriptor[] props;
        if (propertyDescriptorCache == null) {
            propertyDescriptorCache = new HashMap();
        }
        if ((props = (PropertyDescriptor[])propertyDescriptorCache.get(bean.getClass())) == null) {
            LogFactory.getLog(this.getClass()).debug((Object)("Caching property descriptor for " + bean.getClass().getName()));
            props = Introspector.getBeanInfo(bean.getClass(), Object.class).getPropertyDescriptors();
            propertyDescriptorCache.put(bean.getClass(), props);
        }
        return props;
    }

    private class NoClass {
        private NoClass() {
        }
    }
}

