/*
 * Decompiled with CFR 0.152.
 */
package webwork.action.factory;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webwork.action.Action;
import webwork.action.ActionContext;
import webwork.action.factory.ActionFactory;
import webwork.action.factory.ActionFactoryProxy;
import webwork.config.Configuration;
import webwork.util.BeanUtil;

public class ChainingActionFactoryProxy
extends ActionFactoryProxy {
    protected static Log log = LogFactory.getLog(ChainingActionFactoryProxy.class);
    protected int maxLinks = 10;

    public ChainingActionFactoryProxy(ActionFactory aFactory) {
        super(aFactory);
        try {
            this.maxLinks = Integer.parseInt(Configuration.getString("webwork.action.chain.maxlinks"));
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)"Unable to retrieve maximum chain action property. Defaulting to 10.");
        }
    }

    public Action getActionImpl(String aName) throws Exception {
        Action action = this.getNextFactory().getActionImpl(aName);
        ActionContext context = ActionContext.getContext();
        List actions = (List)context.get("action.chain");
        if (actions != null) {
            if (actions.size() + 1 > this.maxLinks) {
                throw new IllegalStateException("Exceeded maximum number of chained actions = " + this.maxLinks);
            }
            Iterator iter = actions.iterator();
            while (iter.hasNext()) {
                BeanUtil.copy(iter.next(), action);
            }
            actions.add(action);
        }
        return action;
    }
}

